/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.rule;

import java.sql.JDBCType;
import java.util.Map;
import net.hasor.cobble.NumberUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.SqlArg;
import net.hasor.db.dal.dynamic.SqlMode;
import net.hasor.db.dal.dynamic.ognl.OgnlUtils;
import net.hasor.db.dal.dynamic.rule.SqlBuildRule;
import net.hasor.db.dialect.SqlBuilder;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class ArgRule
implements SqlBuildRule {
    public static final ArgRule INSTANCE = new ArgRule();
    public static final String CFG_KEY_MODE = "mode";
    public static final String CFG_KEY_JDBC_TYPE = "jdbcType";
    public static final String CFG_KEY_JAVA_TYPE = "javaType";
    public static final String CFG_KEY_HANDLER = "typeHandler";

    private SqlMode convertSqlMode(String sqlMode) {
        if (StringUtils.isNotBlank((String)sqlMode)) {
            for (SqlMode mode : SqlMode.values()) {
                if (!mode.name().equalsIgnoreCase(sqlMode)) continue;
                return mode;
            }
        }
        return null;
    }

    private Integer convertJdbcType(String jdbcType) {
        if (NumberUtils.isNumber((String)jdbcType)) {
            return NumberUtils.createInteger((String)jdbcType);
        }
        if (StringUtils.isNotBlank((String)jdbcType)) {
            for (JDBCType typeElement : JDBCType.values()) {
                if (!typeElement.name().equalsIgnoreCase(jdbcType)) continue;
                return typeElement.getVendorTypeNumber();
            }
        }
        return null;
    }

    private Class<?> convertJavaType(DynamicContext context, String javaType) {
        try {
            if (StringUtils.isNotBlank((String)javaType)) {
                return context.loadClass(javaType);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private TypeHandler<?> convertTypeHandler(DynamicContext context, String typeHandler) {
        try {
            if (StringUtils.isNotBlank((String)typeHandler)) {
                Class<?> aClass = context.loadClass(typeHandler);
                return context.findTypeHandler(aClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Map<String, String> parserConfig(String[] content, int start, int length) {
        LinkedCaseInsensitiveMap exprMap = new LinkedCaseInsensitiveMap();
        for (int i = start; i < length && i < content.length; ++i) {
            String data = content[i];
            String[] kv = data.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException("analysisSQL failed, config must be 'key = value' , '" + content[i] + "' with '" + data + "'");
            }
            if (!StringUtils.isNotBlank((String)kv[0])) continue;
            exprMap.put(kv[0].trim(), kv[1].trim());
        }
        return exprMap;
    }

    @Override
    public void executeRule(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder, String activeExpr, String ruleValue) {
        String[] testSplit = ruleValue.split(",");
        if (testSplit.length > 6 || testSplit.length == 0) {
            throw new IllegalArgumentException("analysisSQL failed, format error -> '#{valueExpr [,mode= IN|OUT|INOUT] [,jdbcType=INT] [,javaType=java.lang.String] [,typeHandler=YouTypeHandlerClassName]}'");
        }
        boolean noExpr = StringUtils.contains((String)testSplit[0], (String)"=");
        String expr = noExpr ? "" : testSplit[0];
        Map<String, String> config = INSTANCE.parserConfig(testSplit, noExpr ? 0 : 1, testSplit.length);
        this.executeRule(data, context, sqlBuilder, expr, config);
    }

    public void executeRule(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder, String expr, Map<String, String> config) {
        Object argValue;
        SqlMode sqlMode = this.convertSqlMode(config != null ? config.get(CFG_KEY_MODE) : null);
        Integer jdbcType = this.convertJdbcType(config != null ? config.get(CFG_KEY_JDBC_TYPE) : null);
        Class<?> javaType = this.convertJavaType(context, config != null ? config.get(CFG_KEY_JAVA_TYPE) : null);
        TypeHandler<Object> typeHandler = this.convertTypeHandler(context, config != null ? config.get(CFG_KEY_HANDLER) : null);
        Object object = argValue = sqlMode == SqlMode.Out ? null : OgnlUtils.evalOgnl(expr, data);
        if (sqlMode == null) {
            sqlMode = SqlMode.In;
        }
        if (javaType == null && argValue != null) {
            javaType = argValue.getClass();
        }
        if (argValue == null && jdbcType == null && javaType == null) {
            jdbcType = 12;
        }
        if (typeHandler == null) {
            if (javaType != null && jdbcType != null) {
                typeHandler = context.findTypeHandler(javaType, jdbcType);
            } else if (javaType != null) {
                typeHandler = context.findTypeHandler(javaType);
            } else if (jdbcType != null) {
                typeHandler = context.findTypeHandler(jdbcType);
            }
        }
        if (typeHandler == null) {
            typeHandler = TypeHandlerRegistry.DEFAULT.getDefaultTypeHandler();
        }
        sqlBuilder.appendSql("?", new SqlArg(expr, argValue, sqlMode, jdbcType, javaType, typeHandler));
    }

    public String toString() {
        return "parameter [" + this.hashCode() + "]";
    }
}

