/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import net.hasor.cobble.io.IOUtils;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class SqlXmlForReaderTypeHandler
extends AbstractTypeHandler<Reader> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Reader parameter, Integer jdbcType) throws SQLException {
        SQLXML sqlxml = ps.getConnection().createSQLXML();
        try {
            Writer writer = sqlxml.setCharacterStream();
            IOUtils.copy((Reader)parameter, (Writer)writer);
            ps.setSQLXML(i, sqlxml);
        }
        catch (IOException e) {
            throw new SQLException("Error copy xml data to SQLXML for parameter #" + i + " with JdbcType " + jdbcType + ", Cause: " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
    }

    @Override
    public Reader getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnName));
    }

    @Override
    public Reader getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(rs.getSQLXML(columnIndex));
    }

    @Override
    public Reader getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.sqlXmlToStream(cs.getSQLXML(columnIndex));
    }

    protected Reader sqlXmlToStream(SQLXML sqlxml) throws SQLException {
        if (sqlxml == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try (Reader reader = sqlxml.getCharacterStream();){
            IOUtils.copy((Reader)reader, (Writer)sw);
        }
        catch (IOException e) {
            throw new SQLException("read chars Xml Data failed : " + e.getMessage(), e);
        }
        finally {
            sqlxml.free();
        }
        return new StringReader(sw.toString());
    }
}

