/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import net.hasor.db.transaction.ConnectionHolder;
import net.hasor.db.transaction.ConnectionHolderImpl;
import net.hasor.db.transaction.ConnectionProxy;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.support.LocalTransactionManager;

public class DataSourceManager {
    private static final ThreadLocal<Map<DataSource, LocalTransactionManager>> managerMap = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final ThreadLocal<Map<DataSource, ConnectionHolder>> holderMap = ThreadLocal.withInitial(ConcurrentHashMap::new);

    private static synchronized LocalTransactionManager createOrGetManager(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, LocalTransactionManager> localMap = managerMap.get();
        return localMap.computeIfAbsent(dataSource, LocalTransactionManager::new);
    }

    private static synchronized ConnectionHolderImpl createOrGetHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, ConnectionHolder> localMap = holderMap.get();
        return (ConnectionHolderImpl)localMap.computeIfAbsent(dataSource, ConnectionHolderImpl::new);
    }

    public static synchronized ConnectionHolder getHolder(DataSource dataSource) {
        return DataSourceManager.createOrGetHolder(dataSource);
    }

    public static TransactionManager getManager(DataSource dataSource) {
        return DataSourceManager.createOrGetManager(dataSource);
    }

    public static TransactionTemplate getTemplate(DataSource dataSource) {
        return DataSourceManager.createOrGetManager(dataSource).getTransactionTemplate();
    }

    protected static void unsafeResetHolder(DataSource dataSource, ConnectionHolder holder) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(holder);
        Map<DataSource, ConnectionHolder> localMap = holderMap.get();
        localMap.put(dataSource, holder);
    }

    protected static void unsafeClearHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, ConnectionHolder> localMap = holderMap.get();
        localMap.remove(dataSource);
    }

    public static Connection getConnection(DataSource dataSource) {
        ConnectionHolderImpl holder = DataSourceManager.createOrGetHolder(dataSource);
        holder.requested();
        CloseSuppressingInvocationHandler handler = new CloseSuppressingInvocationHandler(holder);
        return (ConnectionProxy)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class, Closeable.class}, (InvocationHandler)handler);
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final ConnectionHolderImpl holder;
        private final AtomicBoolean closed;

        CloseSuppressingInvocationHandler(ConnectionHolderImpl holder) {
            this.holder = holder;
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getTargetSource": {
                    return this.holder.getDataSource();
                }
                case "toString": {
                    return this.holder.toString();
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
            }
            if (this.closed.get()) {
                throw new IllegalStateException("connection is close.");
            }
            Connection conn = this.holder.getConnection();
            switch (method.getName()) {
                case "getTargetConnection": {
                    return conn;
                }
                case "setSavepoint": {
                    if (args.length != 0) break;
                    return this.holder.createSavepoint();
                }
                case "close": {
                    if (this.holder.isOpen()) {
                        this.holder.released();
                    }
                    this.closed.set(true);
                    return null;
                }
            }
            try {
                return method.invoke((Object)conn, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

