/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import net.hasor.db.transaction.ConnectionHolder;
import net.hasor.db.transaction.support.SavepointManager;

class ConnectionHolderImpl
implements ConnectionHolder,
SavepointManager {
    private int referenceCount;
    private final DataSource dataSource;
    private Connection connection;
    private static final String SAVEPOINT_NAME_PREFIX = "SAVEPOINT_";
    private int savepointCounter = 0;

    ConnectionHolderImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public synchronized void requested() {
        ++this.referenceCount;
    }

    @Override
    public synchronized void released() throws SQLException {
        --this.referenceCount;
        if (!this.isOpen() && this.connection != null) {
            try {
                this.savepointCounter = 0;
                this.connection.close();
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public int getRefCount() {
        return this.referenceCount;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (!this.isOpen()) {
            return null;
        }
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    @Override
    public boolean isOpen() {
        return this.referenceCount != 0;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    private Connection checkConn(Connection conn) throws SQLException {
        if (conn == null) {
            throw new SQLException("Connection is null.");
        }
        return conn;
    }

    @Override
    public boolean supportSavepoint() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new IllegalStateException("connection is close.");
        }
        return conn.getMetaData().supportsSavepoints();
    }

    @Override
    public Savepoint createSavepoint() throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        ++this.savepointCounter;
        return conn.setSavepoint(SAVEPOINT_NAME_PREFIX + this.savepointCounter);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Connection conn = this.checkConn(this.getConnection());
        conn.rollback(savepoint);
    }
}

