/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.db.mapping.Column;
import net.hasor.db.mapping.Ignore;
import net.hasor.db.mapping.Table;
import net.hasor.db.mapping.def.ColumnDef;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.mapping.resolve.TableMappingResolve;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class ClassTableMappingResolve
implements TableMappingResolve<Class<?>> {
    private static final Map<Class<?>, Class<?>> CLASS_MAPPING_MAP = new HashMap();
    private static final Pattern humpPattern;

    public static TableDef<?> resolveTableMapping(Class<?> entityType, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) {
        return new ClassTableMappingResolve().resolveTableMapping(entityType, classLoader, typeRegistry, (MappingOptions)null);
    }

    @Override
    public TableDef<?> resolveTableMapping(Class<?> entityType, ClassLoader classLoader, TypeHandlerRegistry typeRegistry, MappingOptions options) {
        options = new MappingOptions(options);
        TableDef<?> def = this.resolveTable(entityType, options);
        Map properties = BeanUtils.getPropertyFunc(entityType);
        ArrayList<String> names = new ArrayList<String>();
        List fields = BeanUtils.getALLFields(entityType).values().stream().map(Field::getName).collect(Collectors.toList());
        for (String name : fields) {
            if (!properties.containsKey(name)) continue;
            names.add(name);
        }
        for (String name : properties.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            Property property = (Property)properties.get(name);
            Class type = BeanUtils.getPropertyType((Property)property);
            this.resolveProperty(def, name, type, property, typeRegistry, options);
        }
        return def;
    }

    protected <V> TableDef<V> resolveTable(Class<V> entityType, MappingOptions options) {
        if (entityType.isAnnotationPresent(Table.class)) {
            String table;
            Table defTable = entityType.getAnnotation(Table.class);
            String schema = defTable.schema();
            String string = StringUtils.isNotBlank((String)defTable.name()) ? defTable.name() : (table = StringUtils.isNotBlank((String)defTable.value()) ? defTable.value() : entityType.getSimpleName());
            if (defTable.mapUnderscoreToCamelCase() || Boolean.TRUE.equals(options.getMapUnderscoreToCamelCase())) {
                schema = ClassTableMappingResolve.humpToLine(schema, true);
                table = ClassTableMappingResolve.humpToLine(table, true);
                options.setMapUnderscoreToCamelCase(true);
            }
            boolean autoProperty = defTable.autoMapping();
            boolean useDelimited = defTable.useDelimited();
            boolean caseInsensitive = defTable.caseInsensitive() || options.getCaseInsensitive() == null || Boolean.TRUE.equals(options.getCaseInsensitive());
            return new TableDef<V>(schema, table, entityType, autoProperty, useDelimited, caseInsensitive);
        }
        String tableName = ClassTableMappingResolve.humpToLine(entityType.getSimpleName(), options.getMapUnderscoreToCamelCase());
        return new TableDef<V>(null, tableName, entityType, true, false, true);
    }

    private void resolveProperty(TableDef<?> tableDef, String name, Class<?> type, Property handler, TypeHandlerRegistry typeRegistry, MappingOptions options) {
        boolean primary;
        boolean update;
        boolean insert;
        TypeHandler<?> typeHandler;
        int jdbcType;
        Class<?> javaType;
        String column;
        Annotation[] annotations = BeanUtils.getPropertyAnnotation((Property)handler);
        Column info = null;
        for (Annotation a : annotations) {
            if (info == null && a instanceof Column) {
                info = (Column)a;
                continue;
            }
            if (!(a instanceof Ignore)) continue;
            return;
        }
        if (info != null) {
            String string = column = StringUtils.isNotBlank((String)info.name()) ? info.name() : info.value();
            if (StringUtils.isBlank((String)column)) {
                column = ClassTableMappingResolve.humpToLine(name, options.getMapUnderscoreToCamelCase());
            }
            javaType = info.specialJavaType() == Object.class ? CLASS_MAPPING_MAP.getOrDefault(type, type) : info.specialJavaType();
            jdbcType = info.jdbcType();
            if (info.jdbcType() == 2000) {
                jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            }
            typeHandler = typeRegistry.getTypeHandler(javaType, jdbcType);
            insert = info.insert();
            update = info.update();
            primary = info.primary();
        } else if (tableDef.isAutoProperty()) {
            column = ClassTableMappingResolve.humpToLine(name, options.getMapUnderscoreToCamelCase());
            javaType = CLASS_MAPPING_MAP.getOrDefault(type, type);
            jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            typeHandler = typeRegistry.getTypeHandler(javaType, jdbcType);
            insert = true;
            update = true;
            primary = false;
        } else {
            return;
        }
        tableDef.addMapping(new ColumnDef(column, name, jdbcType, javaType, typeHandler, handler, insert, update, primary));
    }

    private static String humpToLine(String str, Boolean mapUnderscoreToCamelCase) {
        if (StringUtils.isBlank((String)str) || mapUnderscoreToCamelCase == null || !mapUnderscoreToCamelCase.booleanValue()) {
            return str;
        }
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        String strString = sb.toString();
        strString = strString.replaceAll("_{2,}", "_");
        if (strString.charAt(0) == '_') {
            strString = strString.substring(1);
        }
        return strString;
    }

    static {
        CLASS_MAPPING_MAP.put(List.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(Set.class, HashSet.class);
        CLASS_MAPPING_MAP.put(Map.class, HashMap.class);
        humpPattern = Pattern.compile("[A-Z]");
    }
}

