/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.types.TypeHandler;

public class DefaultTableReader<T>
implements TableReader<T> {
    private final Class<T> mapperClass;
    private final TableMapping<T> tableMapping;

    public DefaultTableReader(Class<T> mapperClass, TableMapping<T> tableMapping) {
        this.mapperClass = mapperClass;
        this.tableMapping = tableMapping;
    }

    public TableMapping<T> getTableMapping() {
        return this.tableMapping;
    }

    @Override
    public List<T> extractData(List<String> columns, ResultSet rs) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.extractRow(columns, rs, rowNum++));
        }
        return results;
    }

    @Override
    public T extractRow(List<String> columns, ResultSet rs, int rowNum) throws SQLException {
        T target = null;
        try {
            target = this.mapperClass.newInstance();
        }
        catch (Exception e) {
            throw new SQLException("newInstance " + this.mapperClass.getName() + " failed.", e);
        }
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            ColumnMapping mapping = this.tableMapping.getPropertyByColumn(column);
            if (mapping == null || mapping.getHandler().isReadOnly()) continue;
            TypeHandler<?> realHandler = mapping.getTypeHandler();
            Object result = realHandler.getResult(rs, i + 1);
            mapping.getHandler().set(target, result);
        }
        return target;
    }
}

