/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.UpdateExecute;
import net.hasor.db.lambda.core.AbstractQueryCompare;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;

public class LambdaUpdateWrapper<T>
extends AbstractQueryCompare<T, LambdaOperations.LambdaUpdate<T>>
implements LambdaOperations.LambdaUpdate<T> {
    protected final Map<String, ColumnMapping> allowUpdateProperties = new LinkedHashMap<String, ColumnMapping>();
    protected final Map<String, Object> updateValueMap;
    private boolean allowEmptyWhere = false;

    public LambdaUpdateWrapper(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(tableMapping, jdbcTemplate);
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            if (!mapping.isUpdate()) continue;
            this.allowUpdateProperties.put(mapping.getProperty(), mapping);
        }
        this.updateValueMap = new HashMap<String, Object>();
    }

    @Override
    protected boolean supportPage() {
        return false;
    }

    @Override
    protected LambdaOperations.LambdaUpdate<T> getSelf() {
        return this;
    }

    @Override
    public LambdaOperations.LambdaUpdate<T> useQualifier() {
        this.enableQualifier();
        return this;
    }

    @Override
    public UpdateExecute<T> allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this;
    }

    @Override
    public UpdateExecute<T> updateByColumn(Map<String, Object> newValue) {
        Predicate<ColumnMapping> tester = m -> newValue.containsKey(m.getColumn());
        Function<ColumnMapping, Object> reader = m -> newValue.get(m.getColumn());
        return this.updateTo(tester, reader);
    }

    @Override
    public UpdateExecute<T> updateByColumn(Collection<String> setColumns, T newValue) {
        if (newValue == null || setColumns == null || setColumns.isEmpty()) {
            throw new NullPointerException("newValue / setColumns is null or empty.");
        }
        HashMap<String, Object> tempData = new HashMap<String, Object>();
        for (Map.Entry<String, ColumnMapping> mappingEntry : this.allowUpdateProperties.entrySet()) {
            ColumnMapping mapping = mappingEntry.getValue();
            if (!setColumns.contains(mapping.getColumn())) continue;
            Object value = mapping.getHandler().get(newValue);
            tempData.put(mappingEntry.getKey(), value);
        }
        Predicate<ColumnMapping> tester = m -> tempData.containsKey(m.getProperty());
        Function<ColumnMapping, Object> reader = m -> tempData.get(m.getProperty());
        return this.updateTo(tester, reader);
    }

    @Override
    public UpdateExecute<T> updateTo(T newValue) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        Predicate<ColumnMapping> tester = m -> true;
        Function<ColumnMapping, Object> reader = m -> m.getHandler().get(newValue);
        return this.updateTo(tester, reader);
    }

    @Override
    public UpdateExecute<T> updateBySample(T sample) {
        if (sample == null) {
            throw new NullPointerException("sample is null.");
        }
        HashMap<String, Object> tempData = new HashMap<String, Object>();
        for (Map.Entry<String, ColumnMapping> mappingEntry : this.allowUpdateProperties.entrySet()) {
            Object value = mappingEntry.getValue().getHandler().get(sample);
            if (value == null) continue;
            tempData.put(mappingEntry.getKey(), value);
        }
        Predicate<ColumnMapping> tester = m -> tempData.containsKey(m.getProperty());
        Function<ColumnMapping, Object> reader = m -> tempData.get(m.getProperty());
        return this.updateTo(tester, reader);
    }

    protected UpdateExecute<T> updateTo(Predicate<ColumnMapping> tester, Function<ColumnMapping, Object> propertyReader) {
        if (tester == null) {
            throw new NullPointerException("tester is null.");
        }
        this.updateValueMap.clear();
        HashSet<String> updateColumns = new HashSet<String>();
        for (Map.Entry<String, ColumnMapping> allowFieldEntry : this.allowUpdateProperties.entrySet()) {
            ColumnMapping allowProperty = allowFieldEntry.getValue();
            if (!tester.test(allowProperty)) continue;
            String columnName = allowProperty.getColumn();
            String propertyName = allowProperty.getProperty();
            if (updateColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            updateColumns.add(columnName);
            Object propertyValue = propertyReader.apply(allowProperty);
            this.updateValueMap.put(propertyName, propertyValue);
        }
        return this;
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        if (this.updateValueMap.isEmpty()) {
            return null;
        }
        this.queryParam.clear();
        MergeSqlSegment updateTemplate = new MergeSqlSegment(new Segment[0]);
        updateTemplate.addSegment(SqlKeyword.UPDATE);
        TableMapping tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        String table = this.dialect().tableName(this.isQualifier(), schemaName, tableName);
        updateTemplate.addSegment(() -> table);
        updateTemplate.addSegment(SqlKeyword.SET);
        boolean isFirstColumn = true;
        for (String propertyName : this.updateValueMap.keySet()) {
            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                updateTemplate.addSegment(() -> ",");
            }
            ColumnMapping mapping = this.allowUpdateProperties.get(propertyName);
            String columnName = this.dialect().columnName(this.isQualifier(), schemaName, tableName, mapping.getColumn());
            Object columnValue = this.updateValueMap.get(propertyName);
            updateTemplate.addSegment(() -> columnName, SqlKeyword.EQ, this.formatSegment(columnValue));
        }
        if (!this.queryTemplate.isEmpty()) {
            updateTemplate.addSegment(SqlKeyword.WHERE);
            updateTemplate.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous UPDATE operation, You must call `allowEmptyWhere()` to enable UPDATE ALL.");
        }
        String sqlQuery = updateTemplate.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }

    @Override
    public int doUpdate() throws SQLException {
        if (this.updateValueMap.isEmpty()) {
            throw new IllegalStateException("Nothing to update.");
        }
        BoundSql boundSql = this.getBoundSql();
        String sqlString = boundSql.getSqlString();
        return this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
    }
}

