/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.core.AbstractExecute;
import net.hasor.db.lambda.core.LambdaDeleteWrapper;
import net.hasor.db.lambda.core.LambdaInsertWrapper;
import net.hasor.db.lambda.core.LambdaQueryWrapper;
import net.hasor.db.lambda.core.LambdaUpdateWrapper;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.mapping.resolve.ClassTableMappingResolve;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.types.TypeHandlerRegistry;

public class LambdaTemplate
extends JdbcTemplate
implements LambdaOperations {
    protected final Map<Class<?>, TableMapping<?>> tableMapping = new HashMap();
    protected SqlDialect dialect = null;

    public LambdaTemplate() {
        this.initTypeReader();
    }

    public LambdaTemplate(DataSource dataSource) {
        super(dataSource);
        this.initTypeReader();
    }

    public LambdaTemplate(DataSource dataSource, TypeHandlerRegistry typeRegistry) {
        super(dataSource, typeRegistry);
        this.initTypeReader();
    }

    public LambdaTemplate(Connection conn) {
        super(conn);
        this.initTypeReader();
    }

    public LambdaTemplate(Connection conn, TypeHandlerRegistry typeRegistry) {
        super(conn, typeRegistry);
    }

    protected void initTypeReader() {
    }

    public void setDialect(SqlDialect dialect) {
        this.dialect = dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> TableMapping<T> getTableMapping(Class<T> exampleType, MappingOptions options) {
        if (exampleType == null) {
            throw new NullPointerException("exampleType is null.");
        }
        if (exampleType == Map.class) {
            throw new UnsupportedOperationException("Map cannot be used as lambda exampleType.");
        }
        TableMapping<?> mapping = this.tableMapping.get(exampleType);
        if (mapping != null) {
            return mapping;
        }
        LambdaTemplate lambdaTemplate = this;
        synchronized (lambdaTemplate) {
            mapping = this.tableMapping.get(exampleType);
            if (mapping != null) {
                return mapping;
            }
            options = new MappingOptions(options);
            options.setCaseInsensitive(this.isResultsCaseInsensitive());
            TableDef<?> tableMapping = new ClassTableMappingResolve().resolveTableMapping(exampleType, exampleType.getClassLoader(), this.getTypeRegistry(), options);
            return tableMapping;
        }
    }

    protected SqlDialect getDefaultDialect() {
        return this.dialect;
    }

    private <T, E extends AbstractExecute<T>> E configDialect(E execute) {
        SqlDialect dialect = this.getDefaultDialect();
        if (dialect != null) {
            execute.setDialect(dialect);
        }
        return execute;
    }

    @Override
    public <T> LambdaOperations.LambdaQuery<T> lambdaQuery(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new LambdaQueryWrapper<T>(this.getTableMapping(exampleType, options), this));
    }

    @Override
    public <T> LambdaOperations.LambdaDelete<T> lambdaDelete(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new LambdaDeleteWrapper<T>(this.getTableMapping(exampleType, options), this));
    }

    @Override
    public <T> LambdaOperations.LambdaUpdate<T> lambdaUpdate(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new LambdaUpdateWrapper<T>(this.getTableMapping(exampleType, options), this));
    }

    @Override
    public <T> LambdaOperations.LambdaInsert<T> lambdaInsert(Class<T> exampleType, MappingOptions options) {
        return this.configDialect(new LambdaInsertWrapper<T>(this.getTableMapping(exampleType, options), this));
    }
}

