/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.reflect.SFunction;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.QueryExecute;
import net.hasor.db.lambda.core.AbstractQueryCompare;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.OrderByKeyword;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.page.Page;

public class LambdaQueryWrapper<T>
extends AbstractQueryCompare<T, LambdaOperations.LambdaQuery<T>>
implements LambdaOperations.LambdaQuery<T> {
    private final List<Segment> customSelect = new ArrayList<Segment>();
    private final List<Segment> groupBySegments = new ArrayList<Segment>();
    private final List<Segment> orderBySegments = new ArrayList<Segment>();
    private boolean lockGroupBy = false;
    private boolean lockOrderBy = false;

    public LambdaQueryWrapper(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(tableMapping, jdbcTemplate);
    }

    @Override
    protected boolean supportPage() {
        return true;
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        this.queryParam.clear();
        String sqlQuery = this.reBuildSql();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }

    private String reBuildSql() {
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        sqlSegment.addSegment(SqlKeyword.SELECT);
        sqlSegment.addSegment(LambdaQueryWrapper.buildColumns(this.groupBySegments.isEmpty() ? this.customSelect : this.groupBySegments));
        sqlSegment.addSegment(SqlKeyword.FROM);
        sqlSegment.addSegment(this.buildTabName(this.dialect()));
        if (!this.queryTemplate.isEmpty()) {
            Segment firstSqlSegment = this.queryTemplate.firstSqlSegment();
            if (firstSqlSegment == SqlKeyword.GROUP_BY || firstSqlSegment == SqlKeyword.HAVING || firstSqlSegment == SqlKeyword.ORDER_BY) {
                sqlSegment.addSegment(this.queryTemplate);
            } else {
                sqlSegment.addSegment(SqlKeyword.WHERE);
                sqlSegment.addSegment(this.queryTemplate.sub(1));
            }
        }
        return sqlSegment.getSqlSegment();
    }

    private static Segment buildColumns(Collection<Segment> columnSegments) {
        if (columnSegments.isEmpty()) {
            return SqlKeyword.COLUMNS;
        }
        return LambdaQueryWrapper.buildBySeparator(columnSegments, ",");
    }

    private static Segment buildBySeparator(Collection<Segment> orderBySegments, String separator) {
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Segment> columnIterator = orderBySegments.iterator();
        while (columnIterator.hasNext()) {
            Segment entry = columnIterator.next();
            sqlSegment.addSegment(entry);
            if (!columnIterator.hasNext()) continue;
            sqlSegment.addSegment(() -> separator);
        }
        return sqlSegment;
    }

    protected void lockGroupBy() {
        this.lockCondition();
        this.lockGroupBy = true;
    }

    protected void lockOrderBy() {
        this.lockGroupBy();
        this.lockOrderBy = true;
    }

    @Override
    protected LambdaOperations.LambdaQuery<T> getSelf() {
        return this;
    }

    @Override
    public QueryExecute<T> useQualifier() {
        this.enableQualifier();
        return this;
    }

    @Override
    public LambdaOperations.LambdaQuery<T> selectAll() {
        this.customSelect.clear();
        return this;
    }

    @Override
    public final LambdaOperations.LambdaQuery<T> select(SFunction<T> ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IndexOutOfBoundsException("properties is empty. please use selectAll()");
        }
        TableMapping tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        List columns = Arrays.stream(properties).map(tsFunction -> {
            String property = BeanUtils.toProperty((SFunction)tsFunction);
            ColumnMapping mapping = tableMapping.getPropertyByName(property);
            if (mapping != null) {
                return this.dialect().columnName(this.isQualifier(), schemaName, tableName, mapping.getColumn());
            }
            return null;
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        for (String col : columns) {
            this.customSelect.add(() -> col);
        }
        return this;
    }

    @Override
    public LambdaOperations.LambdaQuery<T> select(String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new IndexOutOfBoundsException("columns is empty. please use selectAll()");
        }
        for (String col : columns) {
            this.customSelect.add(() -> col);
        }
        return this;
    }

    @Override
    public final LambdaOperations.LambdaQuery<T> groupBy(SFunction<T> ... properties) {
        if (this.lockGroupBy) {
            throw new IllegalStateException("group by is locked.");
        }
        this.lockCondition();
        if (properties != null && properties.length > 0) {
            if (this.groupBySegments.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.GROUP_BY);
            }
            ArrayList<Segment> groupBySeg = new ArrayList<Segment>();
            for (SFunction<T> fun : properties) {
                groupBySeg.add(() -> this.conditionName(fun));
            }
            this.groupBySegments.addAll(groupBySeg);
            this.queryTemplate.addSegment(LambdaQueryWrapper.buildBySeparator(groupBySeg, ","));
        }
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> orderBy(SFunction<T> ... properties) {
        return this.addOrderBy(OrderByKeyword.ORDER_DEFAULT, properties);
    }

    @Override
    public LambdaOperations.LambdaQuery<T> asc(SFunction<T> ... properties) {
        return this.addOrderBy(OrderByKeyword.ASC, properties);
    }

    @Override
    public LambdaOperations.LambdaQuery<T> desc(SFunction<T> ... properties) {
        return this.addOrderBy(OrderByKeyword.DESC, properties);
    }

    private LambdaOperations.LambdaQuery<T> addOrderBy(OrderByKeyword keyword, SFunction<T> ... orderBy) {
        if (this.lockOrderBy) {
            throw new IllegalStateException("order by is locked.");
        }
        this.lockGroupBy();
        if (orderBy != null && orderBy.length > 0) {
            if (this.orderBySegments.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.ORDER_BY);
            } else {
                this.queryTemplate.addSegment(() -> ",");
            }
            ArrayList<Segment> orderBySeg = new ArrayList<Segment>();
            for (SFunction<T> fun : orderBy) {
                MergeSqlSegment orderByItem = new MergeSqlSegment(() -> this.conditionName(fun), keyword);
                orderBySeg.add(orderByItem);
            }
            this.orderBySegments.addAll(orderBySeg);
            this.queryTemplate.addSegment(LambdaQueryWrapper.buildBySeparator(orderBySeg, ","));
        }
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> usePage(Page pageInfo) {
        Page page = this.pageInfo();
        page.setPageSize(pageInfo.getPageSize());
        page.setCurrentPage(pageInfo.getCurrentPage());
        page.setPageNumberOffset(pageInfo.getPageNumberOffset());
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> initPage(int pageSize, int pageNumber) {
        Page pageInfo = this.pageInfo();
        pageInfo.setPageNumberOffset(0);
        pageInfo.setPageSize(pageSize);
        pageInfo.setCurrentPage(pageNumber);
        return this.getSelf();
    }
}

