/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.db.dialect.BatchBoundSql;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.lambda.DuplicateKeyStrategy;
import net.hasor.db.lambda.InsertExecute;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.core.AbstractExecute;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;

public class LambdaInsertWrapper<T>
extends AbstractExecute<T>
implements LambdaOperations.LambdaInsert<T> {
    private final List<ColumnMapping> insertProperties = this.getInsertProperties();
    private final List<ColumnMapping> primaryKeyProperties = this.getPrimaryKeyColumns();
    private final List<Object[]> insertValues = new ArrayList<Object[]>();
    private DuplicateKeyStrategy insertStrategy = DuplicateKeyStrategy.Into;

    public LambdaInsertWrapper(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(tableMapping, jdbcTemplate);
    }

    @Override
    public LambdaOperations.LambdaInsert<T> useQualifier() {
        this.enableQualifier();
        return this;
    }

    @Override
    public InsertExecute<T> onDuplicateStrategy(DuplicateKeyStrategy insertStrategy) {
        this.insertStrategy = Objects.requireNonNull(insertStrategy);
        return this;
    }

    protected List<ColumnMapping> getInsertProperties() {
        TableMapping tableMapping = this.getTableMapping();
        ArrayList<ColumnMapping> toInsertProperties = new ArrayList<ColumnMapping>();
        HashSet<String> insertColumns = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            String columnName = mapping.getColumn();
            if (!mapping.isInsert()) continue;
            if (insertColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            insertColumns.add(columnName);
            toInsertProperties.add(mapping);
        }
        if (toInsertProperties.size() == 0) {
            throw new IllegalStateException("no column require INSERT.");
        }
        return toInsertProperties;
    }

    protected List<ColumnMapping> getPrimaryKeyColumns() {
        TableMapping tableMapping = this.getTableMapping();
        ArrayList<ColumnMapping> pkProperties = new ArrayList<ColumnMapping>();
        HashSet<String> pkColumns = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            String columnName = mapping.getColumn();
            if (!mapping.isPrimaryKey()) continue;
            if (pkColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            pkColumns.add(columnName);
            pkProperties.add(mapping);
        }
        return pkProperties;
    }

    @Override
    public InsertExecute<T> applyEntity(List<T> entityList) {
        int propertyCount = this.insertProperties.size();
        for (T entity : entityList) {
            Object[] args = new Object[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                ColumnMapping mapping = this.insertProperties.get(i);
                args[i] = mapping.getHandler().get(entity);
            }
            this.insertValues.add(args);
        }
        return this;
    }

    @Override
    public InsertExecute<T> applyMap(List<Map<String, Object>> columnMapList) {
        int propertyCount = this.insertProperties.size();
        for (Map<String, Object> columnMap : columnMapList) {
            Object[] args = new Object[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                ColumnMapping mapping = this.insertProperties.get(i);
                args[i] = columnMap.get(mapping.getColumn());
            }
            this.insertValues.add(args);
        }
        return this;
    }

    @Override
    public BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect());
    }

    @Override
    public BoundSql getBoundSql(SqlDialect dialect) {
        if (this.insertValues.size() == 0) {
            throw new IllegalStateException("there is no data to insert");
        }
        boolean isInsertSqlDialect = dialect instanceof InsertSqlDialect;
        if (isInsertSqlDialect) {
            return this.dialectInsert((InsertSqlDialect)dialect);
        }
        throw new UnsupportedOperationException(dialect.getClass().getName() + " does not implement InsertSqlDialect.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeGetResult() throws SQLException {
        try {
            BoundSql boundSql = this.getBoundSql();
            String sqlString = boundSql.getSqlString();
            if (boundSql instanceof BatchBoundSql) {
                if (boundSql.getArgs().length > 1) {
                    int[] nArray = this.getJdbcTemplate().executeBatch(sqlString, ((BatchBoundSql)boundSql).getArgs());
                    return nArray;
                }
                int i = this.getJdbcTemplate().executeUpdate(sqlString, (Object[])boundSql.getArgs()[0]);
                int[] nArray = new int[]{i};
                return nArray;
            }
            int i = this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
            int[] nArray = new int[]{i};
            return nArray;
        }
        finally {
            this.insertValues.clear();
        }
    }

    protected BoundSql dialectInsert(InsertSqlDialect dialect) {
        TableMapping tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        List<String> primaryKeys = this.primaryKeyProperties.parallelStream().map(ColumnMapping::getColumn).collect(Collectors.toList());
        List<String> insertColumns = this.insertProperties.parallelStream().map(ColumnMapping::getColumn).collect(Collectors.toList());
        switch (this.insertStrategy) {
            case Into: {
                if (!dialect.supportInsertInto(primaryKeys, insertColumns)) break;
                String sqlString = dialect.insertWithInto(this.isQualifier(), schemaName, tableName, primaryKeys, insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
            case Ignore: {
                if (!dialect.supportInsertIgnore(primaryKeys, insertColumns)) break;
                String sqlString = dialect.insertWithIgnore(this.isQualifier(), schemaName, tableName, primaryKeys, insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
            case Update: {
                if (!dialect.supportUpsert(primaryKeys, insertColumns)) break;
                String sqlString = dialect.insertWithUpsert(this.isQualifier(), schemaName, tableName, primaryKeys, insertColumns);
                return this.buildBatchBoundSql(sqlString);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this.insertStrategy) + " Unsupported.");
    }

    protected BatchBoundSql buildBatchBoundSql(String batchSql) {
        Object[][] args = new Object[this.insertValues.size()][];
        for (int i = 0; i < this.insertValues.size(); ++i) {
            args[i] = this.insertValues.get(i);
        }
        return new BatchBoundSql.BatchBoundSqlObj(batchSql, args);
    }
}

