/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.function.ESupplier;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.lambda.QueryExecute;
import net.hasor.db.lambda.core.AbstractExecute;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.mapping.def.TableMapping;
import net.hasor.db.mapping.resolve.MappingOptions;
import net.hasor.db.page.Page;
import net.hasor.db.page.PageObject;

public abstract class AbstractQueryExecute<T>
extends AbstractExecute<T>
implements QueryExecute<T> {
    private final Page pageInfo = new PageObject(0, (ESupplier<Integer, SQLException>)((ESupplier)this::queryForCount));

    public AbstractQueryExecute(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(tableMapping, jdbcTemplate);
    }

    AbstractQueryExecute(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate, String dbType, SqlDialect dialect) {
        super(tableMapping, jdbcTemplate, dbType, dialect);
    }

    protected abstract boolean supportPage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BoundSql getBoundSql(SqlDialect dialect) {
        SqlDialect currentSqlDialect = this.dialect();
        try {
            this.setDialect(dialect);
            int pageSize = this.pageInfo.getPageSize();
            if (this.supportPage() && pageSize > 0) {
                int recordPosition = this.pageInfo.getFirstRecordPosition();
                BoundSql boundSql = ((PageSqlDialect)dialect).pageSql(this.getOriginalBoundSql(), recordPosition, pageSize);
                return boundSql;
            }
            BoundSql boundSql = this.getOriginalBoundSql();
            return boundSql;
        }
        finally {
            if (currentSqlDialect != dialect) {
                this.setDialect(currentSqlDialect);
            }
        }
    }

    @Override
    public final BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect());
    }

    protected abstract BoundSql getOriginalBoundSql();

    public Page pageInfo() {
        return this.pageInfo;
    }

    @Override
    public <V> QueryExecute<V> wrapperType(Class<V> wrapperType, MappingOptions options) {
        TableMapping<V> tableMapping = this.getJdbcTemplate().getTableMapping(wrapperType, options);
        final AbstractQueryExecute self = this;
        return new AbstractQueryExecute<V>(tableMapping, this.getJdbcTemplate(), this.dbType, this.dialect()){

            @Override
            protected boolean supportPage() {
                return AbstractQueryExecute.this.supportPage();
            }

            @Override
            protected BoundSql getOriginalBoundSql() {
                return self.getOriginalBoundSql();
            }
        };
    }

    @Override
    public <V> V query(ResultSetExtractor<V> rse) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rse);
    }

    @Override
    public void query(RowCallbackHandler rch) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rch);
    }

    @Override
    public <V> List<V> query(RowMapper<V> rowMapper) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rowMapper);
    }

    private List<String> fetchColumns(ResultSetMetaData rsmd) throws SQLException {
        int nrOfColumns = rsmd.getColumnCount();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            String colName = rsmd.getColumnLabel(i);
            if (colName == null || colName.length() < 1) {
                colName = rsmd.getColumnName(i);
            }
            columnList.add(colName);
        }
        return columnList;
    }

    @Override
    public List<T> queryForList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        TableReader tableReader = this.getTableMapping().toReader();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rs -> {
            List<String> columns = this.fetchColumns(rs.getMetaData());
            return tableReader.extractData(columns, rs);
        });
    }

    @Override
    public T queryForObject() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        TableReader tableReader = this.getTableMapping().toReader();
        return (T)this.getJdbcTemplate().queryForObject(boundSql.getSqlString(), boundSql.getArgs(), (rs, rowNum) -> {
            List<String> columns = this.fetchColumns(rs.getMetaData());
            return tableReader.extractRow(columns, rs, rowNum);
        });
    }

    @Override
    public Map<String, Object> queryForMap() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForMap(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public List<Map<String, Object>> queryForMapList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForList(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public int queryForCount() throws SQLException {
        BoundSql countSql = ((PageSqlDialect)this.dialect()).countSql(this.getOriginalBoundSql());
        return this.getJdbcTemplate().queryForInt(countSql.getSqlString(), countSql.getArgs());
    }

    @Override
    public long queryForLargeCount() throws SQLException {
        BoundSql countSql = ((PageSqlDialect)this.dialect()).countSql(this.getOriginalBoundSql());
        return this.getJdbcTemplate().queryForLong(countSql.getSqlString(), countSql.getArgs());
    }
}

