/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.reflect.SFunction;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.ConditionSqlDialect;
import net.hasor.db.lambda.QueryCompare;
import net.hasor.db.lambda.core.AbstractQueryExecute;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.def.ColumnMapping;
import net.hasor.db.mapping.def.TableMapping;

public abstract class AbstractQueryCompare<T, R>
extends AbstractQueryExecute<T>
implements QueryCompare<T, R> {
    protected MergeSqlSegment queryTemplate = new MergeSqlSegment(new Segment[0]);
    protected List<Object> queryParam = new ArrayList<Object>();
    private Segment nextSegmentPrefix = null;
    private boolean lookCondition = false;

    public AbstractQueryCompare(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(tableMapping, jdbcTemplate);
    }

    @Override
    public R or() {
        this.nextSegmentPrefix = SqlKeyword.OR;
        return this.getSelf();
    }

    @Override
    public R and() {
        this.nextSegmentPrefix = SqlKeyword.AND;
        return this.getSelf();
    }

    @Override
    public R nested(Consumer<QueryCompare<T, R>> lambda) {
        this.addCondition(SqlKeyword.LEFT);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        lambda.accept(this);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        this.addCondition(SqlKeyword.RIGHT);
        return this.getSelf();
    }

    @Override
    public R eq(SFunction<T> property, Object value) {
        return this.eq(this.conditionName(property), value);
    }

    @Override
    public R eq(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.EQ, this.formatValue(value));
    }

    @Override
    public R ne(SFunction<T> property, Object value) {
        return this.ne(this.conditionName(property), value);
    }

    @Override
    public R ne(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NE, this.formatValue(value));
    }

    @Override
    public R gt(SFunction<T> property, Object value) {
        return this.gt(this.conditionName(property), value);
    }

    @Override
    public R gt(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.GT, this.formatValue(value));
    }

    @Override
    public R ge(SFunction<T> property, Object value) {
        return this.ge(this.conditionName(property), value);
    }

    @Override
    public R ge(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.GE, this.formatValue(value));
    }

    @Override
    public R lt(SFunction<T> property, Object value) {
        return this.lt(this.conditionName(property), value);
    }

    @Override
    public R lt(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.LT, this.formatValue(value));
    }

    @Override
    public R le(SFunction<T> property, Object value) {
        return this.le(this.conditionName(property), value);
    }

    @Override
    public R le(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.LE, this.formatValue(value));
    }

    @Override
    public R like(SFunction<T> property, Object value) {
        return this.like(this.conditionName(property), value);
    }

    @Override
    public R like(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public R notLike(SFunction<T> property, Object value) {
        return this.notLike(this.conditionName(property), value);
    }

    @Override
    public R notLike(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.DEFAULT, value));
    }

    @Override
    public R likeRight(SFunction<T> property, Object value) {
        return this.likeRight(this.conditionName(property), value);
    }

    @Override
    public R likeRight(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public R notLikeRight(SFunction<T> property, Object value) {
        return this.notLikeRight(this.conditionName(property), value);
    }

    @Override
    public R notLikeRight(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.RIGHT, value));
    }

    @Override
    public R likeLeft(SFunction<T> property, Object value) {
        return this.likeLeft(this.conditionName(property), value);
    }

    @Override
    public R likeLeft(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public R notLikeLeft(SFunction<T> property, Object value) {
        return this.notLikeLeft(this.conditionName(property), value);
    }

    @Override
    public R notLikeLeft(String column, Object value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(ConditionSqlDialect.SqlLike.LEFT, value));
    }

    @Override
    public R isNull(SFunction<T> property) {
        return this.isNull(this.conditionName(property));
    }

    @Override
    public R isNull(String column) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.IS_NULL);
    }

    @Override
    public R isNotNull(SFunction<T> property) {
        return this.isNotNull(this.conditionName(property));
    }

    @Override
    public R isNotNull(String column) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public R in(SFunction<T> property, Collection<?> value) {
        return this.in(this.conditionName(property), value);
    }

    @Override
    public R in(String column, Collection<?> value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R notIn(SFunction<T> property, Collection<?> value) {
        return this.notIn(this.conditionName(property), value);
    }

    @Override
    public R notIn(String column, Collection<?> value) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NOT, SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R between(SFunction<T> property, Object value1, Object value2) {
        return this.between(this.conditionName(property), value1, value2);
    }

    @Override
    public R between(String column, Object value1, Object value2) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }

    @Override
    public R notBetween(SFunction<T> property, Object value1, Object value2) {
        return this.notBetween(this.conditionName(property), value1, value2);
    }

    @Override
    public R notBetween(String column, Object value1, Object value2) {
        return this.addCondition(() -> this.fmtColumn(column), SqlKeyword.NOT, SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }

    @Override
    public R apply(String sqlString, Object ... args) {
        if (StringUtils.isBlank((String)sqlString)) {
            return this.getSelf();
        }
        this.queryTemplate.addSegment(() -> {
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    this.format(arg);
                }
            }
            return sqlString;
        });
        return this.getSelf();
    }

    protected void lockCondition() {
        this.lookCondition = true;
    }

    protected final R addCondition(Segment ... segments) {
        if (this.lookCondition) {
            throw new UnsupportedOperationException("condition is locked.");
        }
        if (this.nextSegmentPrefix == SqlKeyword.EMPTY) {
            this.nextSegmentPrefix = null;
        } else if (this.nextSegmentPrefix == null) {
            this.queryTemplate.addSegment(SqlKeyword.AND);
            this.nextSegmentPrefix = null;
        } else {
            this.queryTemplate.addSegment(this.nextSegmentPrefix);
            this.nextSegmentPrefix = null;
        }
        for (Segment segment : segments) {
            this.queryTemplate.addSegment(segment);
        }
        return this.getSelf();
    }

    protected abstract R getSelf();

    private Segment formatLikeValue(ConditionSqlDialect.SqlLike like, Object param) {
        return () -> {
            this.format(param);
            return ((ConditionSqlDialect)this.dialect()).like(like, param);
        };
    }

    private Segment formatValue(Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return () -> "";
        }
        MergeSqlSegment mergeSqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Object> iterator = Arrays.asList(params).iterator();
        while (iterator.hasNext()) {
            mergeSqlSegment.addSegment(this.formatSegment(iterator.next()));
            if (!iterator.hasNext()) continue;
            mergeSqlSegment.addSegment(() -> ",");
        }
        return mergeSqlSegment;
    }

    protected Segment formatSegment(Object param) {
        return () -> this.format(param);
    }

    protected String format(Object param) {
        this.queryParam.add(param);
        return "?";
    }

    protected String conditionName(SFunction<T> property) {
        TableMapping tableDef = super.getTableMapping();
        ColumnMapping columnDef = tableDef.getPropertyByName(BeanUtils.toProperty(property));
        return this.dialect().columnName(this.isQualifier(), tableDef.getSchema(), tableDef.getTable(), columnDef.getColumn());
    }

    protected String fmtColumn(String columnName) {
        TableMapping tableDef = super.getTableMapping();
        return this.dialect().columnName(this.isQualifier(), tableDef.getSchema(), tableDef.getTable(), columnName);
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        return new BoundSql(){

            @Override
            public String getSqlString() {
                return AbstractQueryCompare.this.queryTemplate.noFirstSqlSegment();
            }

            @Override
            public Object[] getArgs() {
                return (Object[])AbstractQueryCompare.this.queryParam.toArray().clone();
            }
        };
    }
}

