/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.core;

import java.sql.DatabaseMetaData;
import java.util.Objects;
import net.hasor.db.JdbcUtils;
import net.hasor.db.dialect.DefaultSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.dialect.SqlDialectRegister;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.mapping.def.TableMapping;

public abstract class AbstractExecute<T> {
    protected final String dbType;
    private SqlDialect dialect;
    private final TableMapping<T> tableMapping;
    private final LambdaTemplate jdbcTemplate;
    private boolean qualifier;

    public AbstractExecute(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        this.tableMapping = Objects.requireNonNull(tableMapping, "tableMapping is null.");
        this.jdbcTemplate = jdbcTemplate;
        String tmpDbType = "";
        try {
            tmpDbType = jdbcTemplate.execute(con -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        SqlDialect tempDialect = SqlDialectRegister.findOrCreate(tmpDbType);
        this.dbType = tmpDbType;
        this.dialect = tempDialect == null ? DefaultSqlDialect.DEFAULT : tempDialect;
        this.qualifier = tableMapping.useDelimited();
    }

    AbstractExecute(TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate, String dbType, SqlDialect dialect) {
        this.tableMapping = Objects.requireNonNull(tableMapping, "tableMapping is null.");
        this.jdbcTemplate = jdbcTemplate;
        this.dbType = dbType;
        this.dialect = dialect == null ? DefaultSqlDialect.DEFAULT : dialect;
        this.qualifier = tableMapping.useDelimited();
    }

    public final Class<T> exampleType() {
        return this.tableMapping.entityType();
    }

    public final LambdaTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected final TableMapping<T> getTableMapping() {
        return this.tableMapping;
    }

    protected final SqlDialect dialect() {
        return this.dialect;
    }

    protected final void setDialect(SqlDialect sqlDialect) {
        this.dialect = sqlDialect;
    }

    protected void enableQualifier() {
        this.qualifier = true;
    }

    protected boolean isQualifier() {
        return this.qualifier;
    }

    protected Segment buildTabName(SqlDialect dialect) {
        TableMapping<T> tableMapping = this.getTableMapping();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        return () -> dialect.tableName(this.isQualifier(), schemaName, tableName);
    }
}

