/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.mapping.def.TableDef;
import net.hasor.db.mapping.resolve.ClassTableMappingResolve;
import net.hasor.db.types.TypeHandlerRegistry;

public class MappingResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final TableReader<T> tableReader;

    public MappingResultSetExtractor(Class<T> mapperClass) {
        this(mapperClass, TypeHandlerRegistry.DEFAULT);
    }

    public MappingResultSetExtractor(Class<T> mapperClass, TypeHandlerRegistry typeRegistry) {
        Objects.requireNonNull(mapperClass, "mapperClass is required");
        TableDef<?> tableMapping = ClassTableMappingResolve.resolveTableMapping(mapperClass, mapperClass.getClassLoader(), typeRegistry);
        this.tableReader = tableMapping.toReader();
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            columnList.add(MappingResultSetExtractor.lookupColumnName(rsmd, i));
        }
        return this.tableReader.extractData(columnList, rs);
    }

    private static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }
}

