/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.jdbc.BatchPreparedStatementSetter;
import net.hasor.db.jdbc.CallableStatementCallback;
import net.hasor.db.jdbc.CallableStatementCreator;
import net.hasor.db.jdbc.CallableStatementSetter;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.PreparedStatementCallback;
import net.hasor.db.jdbc.PreparedStatementCreator;
import net.hasor.db.jdbc.PreparedStatementSetter;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.SqlParameter;
import net.hasor.db.jdbc.SqlParameterSource;
import net.hasor.db.jdbc.SqlParameterUtils;
import net.hasor.db.jdbc.StatementCallback;
import net.hasor.db.jdbc.core.ArgPreparedStatementSetter;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.ParameterDisposer;
import net.hasor.db.jdbc.core.ParsedSql;
import net.hasor.db.jdbc.core.StatementSetterUtils;
import net.hasor.db.jdbc.extractor.ColumnMapResultSetExtractor;
import net.hasor.db.jdbc.extractor.MultipleProcessType;
import net.hasor.db.jdbc.extractor.RowCallbackHandlerResultSetExtractor;
import net.hasor.db.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.db.jdbc.extractor.SimpleCallableStatementCallback;
import net.hasor.db.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.db.jdbc.mapper.MappingResultSetExtractor;
import net.hasor.db.jdbc.mapper.MappingRowMapper;
import net.hasor.db.jdbc.mapper.SingleColumnRowMapper;
import net.hasor.db.jdbc.paramer.MapSqlParameterSource;
import net.hasor.db.types.TypeHandlerRegistry;

public class JdbcTemplate
extends JdbcConnection
implements JdbcOperations {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTemplate.class);
    private boolean resultsCaseInsensitive = true;
    private TypeHandlerRegistry typeRegistry = TypeHandlerRegistry.DEFAULT;
    private final Map<String, ParsedSql> parsedSqlCache = new HashMap<String, ParsedSql>();

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public JdbcTemplate(DataSource dataSource, TypeHandlerRegistry typeRegistry) {
        super(dataSource);
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null.");
    }

    public JdbcTemplate(Connection conn) {
        super(conn);
    }

    public JdbcTemplate(Connection conn, TypeHandlerRegistry typeRegistry) {
        super(conn);
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null.");
    }

    public boolean isResultsCaseInsensitive() {
        return this.resultsCaseInsensitive;
    }

    public void setResultsCaseInsensitive(boolean resultsCaseInsensitive) {
        this.resultsCaseInsensitive = resultsCaseInsensitive;
    }

    public TypeHandlerRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void setTypeRegistry(TypeHandlerRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void loadSQL(String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(null, StandardCharsets.UTF_8, sqlResource);
    }

    public void loadSQL(Charset charset, String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(null, charset, sqlResource);
    }

    public void loadSQL(Reader sqlReader) throws IOException, SQLException {
        this.loadSplitSQL(null, sqlReader);
    }

    public void loadSplitSQL(String splitString, String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(splitString, StandardCharsets.UTF_8, sqlResource);
    }

    public void loadSplitSQL(String splitString, Charset charset, String sqlResource) throws IOException, SQLException {
        InputStream inStream = ResourcesUtils.getResourceAsStream((String)sqlResource);
        if (inStream == null) {
            throw new IOException("can't find resource '" + sqlResource + "'");
        }
        InputStreamReader reader = new InputStreamReader(inStream, charset);
        this.loadSplitSQL(splitString, reader);
    }

    public void loadSplitSQL(String splitString, Reader sqlReader) throws IOException, SQLException {
        StringWriter outWriter = new StringWriter();
        IOUtils.copy((Reader)sqlReader, (Writer)outWriter);
        List<String> taskList = null;
        taskList = StringUtils.isBlank((String)splitString) ? Collections.singletonList(outWriter.toString()) : Arrays.asList(outWriter.toString().split(splitString));
        taskList = taskList.parallelStream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        for (String str : taskList) {
            this.execute(str);
        }
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws SQLException {
        Objects.requireNonNull(psc, "PreparedStatementCreator must not be null");
        Objects.requireNonNull(action, "Callback object must not be null");
        if (logger.isDebugEnabled()) {
            String sql = JdbcTemplate.getSql(psc);
            logger.debug("Executing prepared SQL statement " + (sql != null ? " [" + sql + "]" : ""));
        }
        return (T)this.execute((Connection con) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    @Override
    public <T> T execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(this.getPreparedStatementCreator(sql, paramSource), action);
    }

    @Override
    public <T> T execute(String sql, Map<String, ?> paramMap, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), action);
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + sql + "].");
        }
        class ExecuteStatementCallback
        implements StatementCallback<Boolean>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Boolean doInStatement(Statement stmt) throws SQLException {
                return stmt.execute(sql);
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new ExecuteStatementCallback());
    }

    @Override
    public List<Object> multipleExecute(String sql) throws SQLException {
        return this.execute(sql, new MultipleResultExtractor());
    }

    @Override
    public List<Object> multipleExecute(String sql, Object[] args) throws SQLException {
        PreparedStatementSetter pss = this.newArgPreparedStatementSetter(args);
        return this.execute(new SimplePreparedStatementCreator(sql), (PreparedStatement ps) -> {
            try {
                if (pss != null) {
                    pss.setValues(ps);
                }
                Object object = new MultipleResultExtractor().doInPreparedStatement(ps);
                return object;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public List<Object> multipleExecute(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.multipleExecute(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public List<Object> multipleExecute(String sql, SqlParameterSource parameterSource) throws SQLException {
        return this.execute(this.getPreparedStatementCreator(sql, parameterSource), new MultipleResultExtractor());
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws SQLException {
        Objects.requireNonNull(rse, "ResultSetExtractor must not be null.");
        if (logger.isDebugEnabled()) {
            logger.debug("executing prepared SQL query");
        }
        return (T)this.execute(psc, (PreparedStatement ps) -> {
            if (pss != null) {
                pss.setValues(ps);
            }
            try {
                try (ResultSet rs = ps.executeQuery();){
                    Object t = rse.extractData(rs);
                    return t;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws SQLException {
        return this.execute(psc, null, rse);
    }

    @Override
    public <T> T query(final String sql, final ResultSetExtractor<T> rse) throws SQLException {
        Objects.requireNonNull(sql, "SQL must not be null.");
        Objects.requireNonNull(rse, "ResultSetExtractor must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            @Override
            public T doInStatement(Statement stmt) throws SQLException {
                try (ResultSet rs = stmt.executeQuery(sql);){
                    Object t = rse.extractData(rs);
                    return t;
                }
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    @Override
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws SQLException {
        return this.execute(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Override
    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rse);
    }

    @Override
    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rse);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws SQLException {
        this.query(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, RowCallbackHandler rch) throws SQLException {
        this.query(sql, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws SQLException {
        this.query(sql, pss, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, Object[] args, RowCallbackHandler rch) throws SQLException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    @Override
    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws SQLException {
        this.query(this.getPreparedStatementCreator(sql, paramSource), rch);
    }

    @Override
    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws SQLException {
        this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rch);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(psc, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, pss, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
    }

    @Override
    public <T> List<T> query(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rowMapper);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType) throws SQLException {
        return this.query(sql, this.getBeanPropertyResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws SQLException {
        return this.query(sql, args, this.getBeanPropertyResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws SQLException {
        return this.query(sql, paramSource, this.getBeanPropertyResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws SQLException {
        return this.query(sql, paramMap, this.getBeanPropertyResultSetExtractor(elementType));
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws SQLException {
        return JdbcTemplate.requiredSingleResult(this.query(sql, rowMapper));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return JdbcTemplate.requiredSingleResult((Collection)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper, 1)));
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        return JdbcTemplate.requiredSingleResult(this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper));
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, args, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramSource, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramMap, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public long queryForLong(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object[] args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForLong(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int queryForInt(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object[] args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForInt(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public String queryForString(String sql) throws SQLException {
        return this.queryForObject(sql, String.class);
    }

    @Override
    public String queryForString(String sql, Object[] args) throws SQLException {
        return this.queryForObject(sql, args, String.class);
    }

    @Override
    public String queryForString(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.queryForObject(sql, paramSource, String.class);
    }

    @Override
    public String queryForString(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForObject(sql, paramMap, String.class);
    }

    @Override
    public Map<String, Object> queryForMap(String sql) throws SQLException {
        return this.queryForObject(sql, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object[] args) throws SQLException {
        return this.queryForObject(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.queryForObject(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForObject(sql, paramMap, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql) throws SQLException {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object[] args) throws SQLException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.query(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, PreparedStatementSetter args) throws SQLException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public int executeUpdate(PreparedStatementCreator psc, PreparedStatementSetter pss) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("executing prepared SQL update");
        }
        return this.execute(psc, (PreparedStatement ps) -> {
            try {
                if (pss != null) {
                    pss.setValues(ps);
                }
                int rows = ps.executeUpdate();
                if (logger.isDebugEnabled()) {
                    logger.trace("SQL update affected " + rows + " rows.");
                }
                Integer n = rows;
                return n;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public int executeUpdate(PreparedStatementCreator psc) throws SQLException {
        return this.executeUpdate(psc, null);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        Objects.requireNonNull(sql, "SQL must not be null");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL update [" + sql + "].");
        }
        class UpdateStatementCallback
        implements StatementCallback<Integer>,
        SqlProvider {
            UpdateStatementCallback() {
            }

            @Override
            public Integer doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(sql);
                if (logger.isDebugEnabled()) {
                    logger.trace("SQL update affected " + rows + " rows.");
                }
                return rows;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new UpdateStatementCallback());
    }

    @Override
    public int executeUpdate(String sql, PreparedStatementSetter pss) throws SQLException {
        return this.executeUpdate(new SimplePreparedStatementCreator(sql), pss);
    }

    @Override
    public int executeUpdate(String sql, Object[] args) throws SQLException {
        return this.executeUpdate(sql, this.newArgPreparedStatementSetter(args));
    }

    @Override
    public int executeUpdate(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.executeUpdate(this.getPreparedStatementCreator(sql, paramSource));
    }

    @Override
    public int executeUpdate(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.executeUpdate(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)));
    }

    @Override
    public int[] executeBatch(final String[] sql) throws SQLException {
        if (sql == null || sql.length == 0) {
            throw new NullPointerException("SQL array must not be empty");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing SQL batch update of " + sql.length + " statements");
        }
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public int[] doInStatement(Statement stmt) throws SQLException {
                DatabaseMetaData dbmd = stmt.getConnection().getMetaData();
                int[] rowsAffected = new int[sql.length];
                if (dbmd.supportsBatchUpdates()) {
                    String[] stringArray = sql;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String sqlStmt;
                        this.currSql = sqlStmt = stringArray[i];
                        stmt.addBatch(sqlStmt);
                    }
                    rowsAffected = stmt.executeBatch();
                } else {
                    for (int i = 0; i < sql.length; ++i) {
                        this.currSql = sql[i];
                        if (stmt.execute(sql[i])) {
                            throw new SQLException("Invalid batch SQL statement: " + sql[i]);
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public int[] executeBatch(String sql, Map<String, ?>[] batchValues) throws SQLException {
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map<String, ?> values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.executeBatch(sql, batchArgs);
    }

    @Override
    public int[] executeBatch(String sql, final Object[][] batchValues) throws SQLException {
        return this.executeBatch(sql, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                int idx = 1;
                for (Object value : batchValues[i]) {
                    if (value == null) {
                        ps.setObject(idx, null);
                    } else {
                        JdbcTemplate.this.typeRegistry.setParameterValue(ps, idx, value);
                    }
                    ++idx;
                }
            }

            @Override
            public int getBatchSize() {
                return batchValues.length;
            }
        });
    }

    @Override
    public int[] executeBatch(String sql, SqlParameterSource[] batchArgs) throws SQLException {
        if (batchArgs == null || batchArgs.length == 0) {
            return new int[0];
        }
        return this.executeBatch(sql, new SqlParameterSourceBatchPreparedStatementSetter(sql, batchArgs));
    }

    @Override
    public int[] executeBatch(String sql, BatchPreparedStatementSetter pss) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing SQL batch update [" + sql + "].");
        }
        String buildSql = this.getParsedSql(sql).buildSql(null);
        return this.execute(buildSql, (PreparedStatement ps) -> {
            try {
                int batchSize = pss.getBatchSize();
                DatabaseMetaData dbMetaData = ps.getConnection().getMetaData();
                if (dbMetaData.supportsBatchUpdates()) {
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (pss.isBatchExhausted(i)) break;
                        ps.addBatch();
                    }
                    int[] i = ps.executeBatch();
                    return i;
                }
                ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                for (int i = 0; i < batchSize; ++i) {
                    pss.setValues(ps, i);
                    if (pss.isBatchExhausted(i)) break;
                    rowsAffected.add(ps.executeUpdate());
                }
                int[] rowsAffectedArray = new int[rowsAffected.size()];
                for (int i = 0; i < rowsAffectedArray.length; ++i) {
                    rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                }
                int[] nArray = rowsAffectedArray;
                return nArray;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public <T> T call(CallableStatementCreator csc, CallableStatementCallback<T> action) throws SQLException {
        Objects.requireNonNull(csc, "CallableStatementCreator must not be null");
        Objects.requireNonNull(action, "Callback object must not be null");
        if (logger.isDebugEnabled()) {
            String sql = JdbcTemplate.getSql(csc);
            logger.debug("Calling stored procedure" + (sql != null ? " [" + sql + "]" : ""));
        }
        return (T)this.execute((Connection con) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public <T> T call(String callString, CallableStatementCallback<T> action) throws SQLException {
        return this.call((CallableStatementCreator)new SimpleCallableStatementCreator(callString), action);
    }

    @Override
    public <T> T call(String callString, CallableStatementSetter setter, CallableStatementCallback<T> action) throws SQLException {
        return (T)this.call((CallableStatementCreator)new SimpleCallableStatementCreator(callString), (CallableStatement cs) -> {
            try {
                if (setter != null) {
                    setter.setValues(cs);
                }
                Object t = action.doInCallableStatement(cs);
                return t;
            }
            finally {
                if (setter instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)setter)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public Map<String, Object> call(CallableStatementCreator csc, List<SqlParameter> declaredParameters) throws SQLException {
        return this.call(csc, new SimpleCallableStatementCallback(MultipleProcessType.ALL, declaredParameters));
    }

    @Override
    public Map<String, Object> call(String callString, List<SqlParameter> declaredParameters) throws SQLException {
        SimpleCallableStatementCallback csc = new SimpleCallableStatementCallback(MultipleProcessType.ALL, declaredParameters){

            @Override
            public boolean isResultsCaseInsensitive() {
                return JdbcTemplate.this.isResultsCaseInsensitive();
            }

            @Override
            protected Map<String, Object> createResultsMap() {
                return JdbcTemplate.this.createResultsMap();
            }
        };
        return this.call(callString, csc);
    }

    protected static Object processResultSet(boolean caseInsensitive, ResultSet rs, SqlParameter.ReturnSqlParameter param) throws SQLException {
        if (rs != null) {
            if (param != null) {
                if (param.getRowMapper() != null) {
                    RowMapper<?> rowMapper = param.getRowMapper();
                    return new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                }
                if (param.getRowCallbackHandler() != null) {
                    RowCallbackHandler rch = param.getRowCallbackHandler();
                    new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                    return "ResultSet returned from stored procedure was processed";
                }
                if (param.getResultSetExtractor() != null) {
                    return param.getResultSetExtractor().extractData(rs);
                }
            } else {
                return new ColumnMapResultSetExtractor(caseInsensitive).extractData(rs);
            }
        }
        return null;
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper(this.typeRegistry){

            @Override
            protected Map<String, Object> createColumnMap(int columnCount) {
                return JdbcTemplate.this.createResultsMap();
            }
        };
    }

    protected <T> ResultSetExtractor<List<T>> getBeanPropertyResultSetExtractor(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            RowMapper<Map<String, Object>> mapRowMapper = this.getColumnMapRowMapper();
            return new RowMapperResultSetExtractor<Map<String, Object>>(mapRowMapper);
        }
        if (TypeHandlerRegistry.DEFAULT.hasTypeHandler(requiredType) || requiredType.isEnum()) {
            RowMapper<T> mapRowMapper = this.getSingleColumnRowMapper(requiredType);
            return new RowMapperResultSetExtractor<T>(mapRowMapper);
        }
        return new MappingResultSetExtractor<T>(requiredType, this.typeRegistry);
    }

    protected <T> RowMapper<T> getBeanPropertyRowMapper(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            return this.getColumnMapRowMapper();
        }
        if (TypeHandlerRegistry.DEFAULT.hasTypeHandler(requiredType) || requiredType.isEnum()) {
            return this.getSingleColumnRowMapper(requiredType);
        }
        return new MappingRowMapper<T>(requiredType, this.typeRegistry);
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new SingleColumnRowMapper<T>(requiredType, this.typeRegistry);
    }

    protected Map<String, Object> createResultsMap() {
        if (this.isResultsCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap();
        }
        return new LinkedHashMap<String, Object>();
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
        return new ArgPreparedStatementSetter(this.typeRegistry, args);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        return new MapPreparedStatementCreator(sql, paramSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String originalSql) {
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(originalSql);
            if (parsedSql == null) {
                parsedSql = ParsedSql.getParsedSql(originalSql);
                this.parsedSqlCache.put(originalSql, parsedSql);
            }
            return parsedSql;
        }
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static <T> T requiredSingleResult(Collection<T> results) throws SQLException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        int size = results.size();
        if (size > 1) {
            throw new SQLException("Incorrect record count: expected 1, actual " + size);
        }
        return results.iterator().next();
    }

    private class SqlParameterSourceBatchPreparedStatementSetter
    implements BatchPreparedStatementSetter,
    ParameterDisposer {
        private final ParsedSql parsedSql;
        private final SqlParameterSource[] batchArgs;

        public SqlParameterSourceBatchPreparedStatementSetter(String sql, SqlParameterSource[] batchArgs) {
            this.parsedSql = JdbcTemplate.this.getParsedSql(sql);
            this.batchArgs = batchArgs;
        }

        @Override
        public void setValues(PreparedStatement ps, int index) throws SQLException {
            SqlParameterSource paramSource = this.batchArgs[index];
            Object[] sqlValue = this.parsedSql.buildValues(paramSource);
            int sqlColIndex = 1;
            for (Object element : sqlValue) {
                JdbcTemplate.this.typeRegistry.setParameterValue(ps, sqlColIndex++, element);
            }
        }

        @Override
        public int getBatchSize() {
            return this.batchArgs.length;
        }

        @Override
        public void cleanupParameters() {
            for (SqlParameterSource batchItem : this.batchArgs) {
                if (!(batchItem instanceof ParameterDisposer)) continue;
                ((ParameterDisposer)((Object)batchItem)).cleanupParameters();
            }
        }
    }

    private class MapPreparedStatementCreator
    implements PreparedStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private final ParsedSql parsedSql;
        private final SqlParameterSource paramSource;

        public MapPreparedStatementCreator(String originalSql, SqlParameterSource paramSource) {
            Objects.requireNonNull(originalSql, "SQL must not be null");
            this.parsedSql = JdbcTemplate.this.getParsedSql(originalSql);
            this.paramSource = paramSource;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            String sqlToUse = this.parsedSql.buildSql(this.paramSource);
            Object[] paramArray = this.parsedSql.buildValues(this.paramSource);
            PreparedStatement statement = con.prepareStatement(sqlToUse);
            for (int i = 0; i < paramArray.length; ++i) {
                JdbcTemplate.this.typeRegistry.setParameterValue(statement, i + 1, paramArray[i]);
            }
            StatementSetterUtils.cleanupParameters(paramArray);
            return statement;
        }

        @Override
        public String getSql() {
            return this.parsedSql.getOriginalSql();
        }

        @Override
        public void cleanupParameters() {
            if (this.paramSource instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.paramSource)).cleanupParameters();
            }
        }
    }

    private class MultipleResultExtractor
    implements PreparedStatementCallback<List<Object>> {
        private MultipleResultExtractor() {
        }

        @Override
        public List<Object> doInPreparedStatement(PreparedStatement ps) throws SQLException {
            boolean retVal = ps.execute();
            if (logger.isTraceEnabled()) {
                logger.trace("statement.execute() returned '" + retVal + "'");
            }
            ArrayList<Object> resultList = new ArrayList<Object>();
            if (retVal) {
                try (ResultSet resultSet = ps.getResultSet();){
                    ColumnMapRowMapper columnMapRowMapper = new ColumnMapRowMapper(JdbcTemplate.this.typeRegistry);
                    SqlParameter.ReturnSqlParameter result = SqlParameterUtils.withReturnResult("TMP", new RowMapperResultSetExtractor<Map<String, Object>>(columnMapRowMapper));
                    resultList.add(JdbcTemplate.processResultSet(JdbcTemplate.this.isResultsCaseInsensitive(), resultSet, result));
                }
            } else {
                resultList.add(ps.getUpdateCount());
            }
            while (ps.getMoreResults() || ps.getUpdateCount() != -1) {
                int updateCount = ps.getUpdateCount();
                ResultSet resultSet = ps.getResultSet();
                Throwable throwable = null;
                try {
                    if (resultSet != null) {
                        resultList.add(JdbcTemplate.processResultSet(JdbcTemplate.this.isResultsCaseInsensitive(), resultSet, null));
                        continue;
                    }
                    resultList.add(updateCount);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultSet == null) continue;
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resultSet.close();
                }
            }
            return resultList;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            this.callString = Objects.requireNonNull(callString, "Call string must not be null");
        }

        @Override
        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            if (!con.getMetaData().supportsStoredProcedures()) {
                throw new UnsupportedOperationException("target DataSource Unsupported.");
            }
            return con.prepareCall(this.callString);
        }

        @Override
        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            this.sql = Objects.requireNonNull(sql, "SQL must not be null");
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }

    protected static interface SqlProvider {
        public String getSql();
    }
}

