/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.dialect.provider.AbstractDialect;

public class MySqlDialect
extends AbstractDialect
implements PageSqlDialect,
InsertSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/mysql.keywords";
    }

    @Override
    protected String defaultQualifier() {
        return "`";
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        StringBuilder sqlBuilder = new StringBuilder(boundSql.getSqlString());
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (start <= 0) {
            sqlBuilder.append(" LIMIT ?");
            paramArrays.add(limit);
        } else {
            sqlBuilder.append(" LIMIT ?, ?");
            paramArrays.add(start);
            paramArrays.add(limit);
        }
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public boolean supportInsertInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertWithInto(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        return this.buildSql("INSERT INTO ", useQualifier, schema, table, columns, "");
    }

    @Override
    public boolean supportInsertIgnore(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertWithIgnore(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        return this.buildSql("INSERT IGNORE ", useQualifier, schema, table, columns, "");
    }

    @Override
    public boolean supportUpsert(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertWithUpsert(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        return this.buildSql("INSERT INTO ", useQualifier, schema, table, columns, " ON DUPLICATE KEY UPDATE");
    }

    protected String buildSql(String markString, boolean useQualifier, String schema, String table, List<String> columns, String appendSql) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(markString);
        strBuilder.append(this.tableName(useQualifier, schema, table));
        strBuilder.append(" ");
        strBuilder.append("(");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.columnName(useQualifier, schema, table, columns.get(i)));
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        strBuilder.append(appendSql);
        return strBuilder.toString();
    }
}

