/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect;

import java.util.Map;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.cobble.supplier.TypeSupplier;
import net.hasor.db.dialect.DefaultSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.dialect.provider.Db2Dialect;
import net.hasor.db.dialect.provider.DerbyDialect;
import net.hasor.db.dialect.provider.DmDialect;
import net.hasor.db.dialect.provider.H2Dialect;
import net.hasor.db.dialect.provider.HSQLDialect;
import net.hasor.db.dialect.provider.HiveDialect;
import net.hasor.db.dialect.provider.ImpalaDialect;
import net.hasor.db.dialect.provider.InformixDialect;
import net.hasor.db.dialect.provider.KingbaseDialect;
import net.hasor.db.dialect.provider.MariaDBDialect;
import net.hasor.db.dialect.provider.MySqlDialect;
import net.hasor.db.dialect.provider.Oracle12cDialect;
import net.hasor.db.dialect.provider.OracleDialect;
import net.hasor.db.dialect.provider.PhoenixDialect;
import net.hasor.db.dialect.provider.PostgreSqlDialect;
import net.hasor.db.dialect.provider.SqlLiteDialect;
import net.hasor.db.dialect.provider.SqlServer2005Dialect;
import net.hasor.db.dialect.provider.XuGuDialect;

public class SqlDialectRegister {
    private static final Map<String, Class<?>> dialectAliasMap = new LinkedCaseInsensitiveMap();
    private static final Map<String, SqlDialect> dialectCache = new LinkedCaseInsensitiveMap();

    public static void clearDialectCache() {
        dialectCache.clear();
    }

    public static void registerDialectAlias(String dialectName, Class<? extends SqlDialect> dialectClass) {
        dialectAliasMap.put(dialectName, dialectClass);
    }

    public static SqlDialect findOrCreate(String dialectName) {
        return SqlDialectRegister.findOrCreate(dialectName, null, null);
    }

    public static SqlDialect findOrCreate(String dialectName, TypeSupplier typeSupplier) {
        return SqlDialectRegister.findOrCreate(dialectName, null, typeSupplier);
    }

    public static SqlDialect findOrCreate(String dialectName, ClassLoader loader, TypeSupplier typeSupplier) {
        if (StringUtils.isBlank((String)dialectName)) {
            return DefaultSqlDialect.DEFAULT;
        }
        SqlDialect dialect = dialectCache.get(dialectName);
        if (dialect != null) {
            return dialect;
        }
        loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        String lastMessage = null;
        Class aClass = dialectAliasMap.get(dialectName);
        if (aClass == null) {
            try {
                aClass = ResourcesUtils.classForName((ClassLoader)loader, (String)dialectName);
            }
            catch (ClassNotFoundException e) {
                lastMessage = "load dialect '" + dialectName + "' class not found";
            }
        }
        if (aClass != null) {
            if (typeSupplier != null) {
                try {
                    dialect = (SqlDialect)typeSupplier.get(aClass);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                try {
                    dialect = (SqlDialect)aClass.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("load dialect '" + aClass.getName() + "' failed, " + e.getMessage(), e);
                }
            }
        } else {
            if (StringUtils.isNotBlank(lastMessage)) {
                throw new IllegalStateException(lastMessage);
            }
            throw new IllegalStateException("no dialect '" + dialectName + "' found.");
        }
        dialectCache.put(dialectName, dialect);
        return dialect;
    }

    static {
        SqlDialectRegister.registerDialectAlias("db2", Db2Dialect.class);
        SqlDialectRegister.registerDialectAlias("derby", DerbyDialect.class);
        SqlDialectRegister.registerDialectAlias("dm", DmDialect.class);
        SqlDialectRegister.registerDialectAlias("h2", H2Dialect.class);
        SqlDialectRegister.registerDialectAlias("hive", HiveDialect.class);
        SqlDialectRegister.registerDialectAlias("hsql", HSQLDialect.class);
        SqlDialectRegister.registerDialectAlias("impala", ImpalaDialect.class);
        SqlDialectRegister.registerDialectAlias("informix", InformixDialect.class);
        SqlDialectRegister.registerDialectAlias("kingbase", KingbaseDialect.class);
        SqlDialectRegister.registerDialectAlias("mariadb", MariaDBDialect.class);
        SqlDialectRegister.registerDialectAlias("mysql", MySqlDialect.class);
        SqlDialectRegister.registerDialectAlias("oracle12c", Oracle12cDialect.class);
        SqlDialectRegister.registerDialectAlias("oracle", OracleDialect.class);
        SqlDialectRegister.registerDialectAlias("phoenix", PhoenixDialect.class);
        SqlDialectRegister.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlite", SqlLiteDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlserver", SqlServer2005Dialect.class);
        SqlDialectRegister.registerDialectAlias("xugu", XuGuDialect.class);
    }
}

