/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.ConditionSqlDialect;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.PageSqlDialect;

public class DefaultSqlDialect
implements ConditionSqlDialect,
PageSqlDialect,
InsertSqlDialect {
    public static final DefaultSqlDialect DEFAULT = new DefaultSqlDialect();

    @Override
    public Set<String> keywords() {
        return Collections.emptySet();
    }

    @Override
    public String leftQualifier() {
        return "";
    }

    @Override
    public String rightQualifier() {
        return "";
    }

    @Override
    public String tableName(boolean useQualifier, String schema, String table) {
        if (StringUtils.isBlank((String)schema)) {
            return table;
        }
        return schema + "." + table;
    }

    @Override
    public String columnName(boolean useQualifier, String schema, String table, String column) {
        return column;
    }

    @Override
    public BoundSql countSql(BoundSql boundSql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportInsertInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertWithInto(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(this.tableName(useQualifier, schema, table));
        strBuilder.append(" ");
        strBuilder.append("(");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.columnName(useQualifier, schema, table, columns.get(i)));
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public boolean supportInsertIgnore(List<String> primaryKey, List<String> columns) {
        return false;
    }

    @Override
    public String insertWithIgnore(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportUpsert(List<String> primaryKey, List<String> columns) {
        return false;
    }

    @Override
    public String insertWithUpsert(boolean useQualifier, String schema, String table, List<String> primaryKey, List<String> columns) {
        throw new UnsupportedOperationException();
    }
}

