/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.session;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import net.hasor.db.dal.session.DalSession;
import net.hasor.db.dal.session.Mapper;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.core.LambdaTemplate;
import net.hasor.db.page.Page;
import net.hasor.db.page.PageResult;

public interface BaseMapper<T>
extends Mapper {
    public Class<T> entityType();

    public LambdaTemplate template();

    public DalSession getSession();

    default public LambdaOperations.LambdaInsert<T> insert() {
        return this.template().lambdaInsert(this.entityType());
    }

    default public LambdaOperations.LambdaDelete<T> delete() {
        return this.template().lambdaDelete(this.entityType());
    }

    default public LambdaOperations.LambdaUpdate<T> update() {
        return this.template().lambdaUpdate(this.entityType());
    }

    default public LambdaOperations.LambdaQuery<T> query() {
        return this.template().lambdaQuery(this.entityType());
    }

    default public int executeStatement(String stId, Object parameter) throws SQLException {
        return this.getSession().executeStatement(stId, parameter);
    }

    default public <E> List<E> queryStatement(String stId, Object parameter) throws SQLException {
        return this.queryStatement(stId, parameter, null);
    }

    default public <E> List<E> queryStatement(String stId, Object parameter, Page page) throws SQLException {
        return this.getSession().queryStatement(stId, parameter, page);
    }

    default public int save(T entity) throws SQLException {
        return this.insert().applyEntity(entity).executeSumResult();
    }

    default public int save(List<T> entity) throws SQLException {
        return this.insert().applyEntity(entity).executeSumResult();
    }

    public int saveOrUpdate(T var1) throws SQLException;

    public int delete(T var1) throws SQLException;

    public int deleteById(Serializable var1) throws SQLException;

    public int deleteByIds(List<? extends Serializable> var1) throws SQLException;

    public T getById(Serializable var1) throws SQLException;

    public List<T> getByIds(List<? extends Serializable> var1) throws SQLException;

    public List<T> listBySample(T var1) throws SQLException;

    public int countBySample(T var1) throws SQLException;

    public int countAll() throws SQLException;

    public PageResult<T> pageBySample(Object var1, Page var2) throws SQLException;

    default public Page initPageBySample(Object sample, int pageSize) throws SQLException {
        return this.initPageBySample(sample, pageSize, 0);
    }

    public Page initPageBySample(Object var1, int var2, int var3) throws SQLException;
}

