/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.db.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.db.mapping.TableReader;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import net.hasor.db.types.UnknownTypeHandler;

public class MapTableReader
implements TableReader<Map<String, Object>> {
    private final Supplier<Map<String, Object>> objectSupplier = () -> caseInsensitive ? new LinkedCaseInsensitiveMap() : new LinkedHashMap();
    private final ColumnMapRowMapper mapperUtils;

    public MapTableReader(boolean caseInsensitive, TypeHandlerRegistry typeHandler) {
        this.mapperUtils = new ColumnMapRowMapper(caseInsensitive, typeHandler);
    }

    @Override
    public List<Map<String, Object>> extractData(List<String> columns, ResultSet rs) throws SQLException {
        ArrayList handlers = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            handlers.add(this.mapperUtils.getResultSetTypeHandler(rs, i + 1, null));
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.extractRow(columns, handlers, rs, rowNum++));
        }
        return results;
    }

    @Override
    public Map<String, Object> extractRow(List<String> columns, ResultSet rs, int rowNum) throws SQLException {
        ArrayList handlers = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            handlers.add(this.mapperUtils.getResultSetTypeHandler(rs, i + 1, null));
        }
        return this.extractRow(columns, handlers, rs, rowNum);
    }

    protected Map<String, Object> extractRow(List<String> columns, List<TypeHandler<?>> handlers, ResultSet rs, int rowNum) throws SQLException {
        Map<String, Object> target = this.objectSupplier.get();
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i);
            UnknownTypeHandler handler = handlers.get(i);
            if (handler == null) {
                handler = this.mapperUtils.getHandlerRegistry().getDefaultTypeHandler();
            }
            Object result = handler.getResult(rs, i + 1);
            target.put(columnName, result);
        }
        return target;
    }
}

