/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.DynamicSql;
import net.hasor.db.dal.execute.AbstractStatementExecute;
import net.hasor.db.dal.execute.CallableStatementExecute;
import net.hasor.db.dal.execute.KeySequenceExecute;
import net.hasor.db.dal.execute.KeySequenceHolder;
import net.hasor.db.dal.execute.KeySequenceHolderFactory;
import net.hasor.db.dal.execute.PreparedStatementExecute;
import net.hasor.db.dal.execute.StatementExecute;
import net.hasor.db.dal.execute.sequence.SelectKeySequenceHolderFactory;
import net.hasor.db.dal.repository.StatementType;
import net.hasor.db.dal.repository.config.DmlSqlConfig;
import net.hasor.db.dal.repository.config.SelectKeySqlConfig;
import net.hasor.db.dialect.PageSqlDialect;
import net.hasor.db.page.Page;

public class ExecuteProxy {
    private final DmlSqlConfig dynamicSql;
    private final AbstractStatementExecute<?> execute;
    private KeySequenceExecute selectKeyHolder;

    public ExecuteProxy(String dynamicId, DynamicContext context) {
        DynamicSql sqlConfig = context.findDynamic(dynamicId);
        if (!(sqlConfig instanceof DmlSqlConfig)) {
            throw new ClassCastException("dynamic '" + dynamicId + "' is not DmlSqlConfig");
        }
        this.dynamicSql = (DmlSqlConfig)context.findDynamic(dynamicId);
        this.execute = this.buildExecute(this.dynamicSql.getStatementType(), context);
        SelectKeySqlConfig selectKey = ((DmlSqlConfig)sqlConfig).getSelectKey();
        if (selectKey != null) {
            AbstractStatementExecute<?> selectKeyExecute = this.buildExecute(selectKey.getStatementType(), context);
            KeySequenceHolder sequenceHolder = null;
            if (StringUtils.isBlank((String)selectKey.getHandler())) {
                sequenceHolder = new SelectKeySequenceHolderFactory().createHolder(selectKey, selectKeyExecute);
            } else {
                try {
                    Class<?> aClass = context.getClassLoader().loadClass(selectKey.getHandler());
                    KeySequenceHolderFactory holderFactory = (KeySequenceHolderFactory)aClass.newInstance();
                    sequenceHolder = holderFactory.createHolder(selectKey, selectKeyExecute);
                    if (sequenceHolder == null) {
                        throw new NullPointerException("createSelectKeyHolder result is null.");
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntime((Throwable)e);
                }
            }
            this.selectKeyHolder = new KeySequenceExecute(selectKey, sequenceHolder);
        }
    }

    private AbstractStatementExecute<?> buildExecute(StatementType statementType, DynamicContext context) {
        switch (statementType) {
            case Statement: {
                return new StatementExecute(context);
            }
            case Prepared: {
                return new PreparedStatementExecute(context);
            }
            case Callable: {
                return new CallableStatementExecute(context);
            }
        }
        throw new UnsupportedOperationException("statementType '" + statementType.getTypeName() + "' Unsupported.");
    }

    public Object execute(Connection conn, Map<String, Object> data, Page page, boolean pageResult, PageSqlDialect dialect) throws SQLException {
        if (this.selectKeyHolder != null) {
            this.selectKeyHolder.processBefore(conn, data);
        }
        Object result = this.execute.execute(conn, this.dynamicSql, data, page, pageResult, dialect);
        if (this.selectKeyHolder != null) {
            this.selectKeyHolder.processAfter(conn, data);
        }
        return result;
    }
}

