/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.execute;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.execute.MapTableReader;
import net.hasor.db.jdbc.CallableStatementCallback;
import net.hasor.db.jdbc.PreparedStatementCallback;
import net.hasor.db.jdbc.extractor.MultipleProcessType;
import net.hasor.db.mapping.TableReader;

public class DalResultSetExtractor
implements PreparedStatementCallback<List<Object>>,
CallableStatementCallback<List<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(DalResultSetExtractor.class);
    private final TableReader<?> defaultTableReader;
    private final List<TableReader<?>> tableReaders;
    private final MultipleProcessType processType;

    public DalResultSetExtractor(boolean defaultCaseInsensitive, DynamicContext context, MultipleProcessType processType, TableReader<?>[] tableReaders) {
        this.processType = processType == null ? MultipleProcessType.ALL : processType;
        this.tableReaders = Arrays.asList(tableReaders);
        this.defaultTableReader = new MapTableReader(defaultCaseInsensitive, context.getTypeRegistry());
    }

    @Override
    public List<Object> doInCallableStatement(CallableStatement cs) throws SQLException {
        boolean retVal = cs.execute();
        return this.doResult(retVal, cs);
    }

    @Override
    public List<Object> doInPreparedStatement(PreparedStatement ps) throws SQLException {
        boolean retVal = ps.execute();
        return this.doResult(retVal, ps);
    }

    public List<Object> doResult(boolean retVal, Statement stmt) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("statement.execute() returned '" + retVal + "'");
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (retVal) {
            try (ResultSet resultSet = stmt.getResultSet();){
                TableReader<?> tableReader = this.tableReaders.isEmpty() ? this.defaultTableReader : this.tableReaders.get(0);
                resultList.add(this.processResultSet(resultSet, tableReader));
            }
        } else {
            resultList.add(stmt.getUpdateCount());
        }
        if (this.processType == MultipleProcessType.FIRST) {
            return resultList;
        }
        int resultIndex = 1;
        while (stmt.getMoreResults() || stmt.getUpdateCount() != -1) {
            int updateCount = stmt.getUpdateCount();
            Object last = null;
            try (ResultSet resultSet = stmt.getResultSet();){
                last = resultSet != null ? (this.tableReaders.size() > resultIndex ? this.processResultSet(resultSet, this.tableReaders.get(resultIndex++)) : this.processResultSet(resultSet, this.defaultTableReader)) : Integer.valueOf(updateCount);
            }
            if (this.processType == MultipleProcessType.LAST) {
                resultList.set(0, last);
                continue;
            }
            resultList.add(last);
        }
        return resultList;
    }

    protected Object processResultSet(ResultSet rs, TableReader<?> tableReader) throws SQLException {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            columnList.add(DalResultSetExtractor.lookupColumnName(rsmd, i));
        }
        return tableReader.extractData(columnList, rs);
    }

    private static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }
}

