/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.rule;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.SqlArg;
import net.hasor.db.dal.dynamic.SqlMode;
import net.hasor.db.dal.dynamic.rule.SqlBuildRule;
import net.hasor.db.dialect.SqlBuilder;
import net.hasor.db.jdbc.core.ParsedSql;
import net.hasor.db.jdbc.paramer.MapSqlParameterSource;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public abstract class ConditionRule
implements SqlBuildRule {
    private static final TypeHandler<?> stringTypeHandler = TypeHandlerRegistry.DEFAULT.getTypeHandler(String.class);
    private final String prefix;

    protected ConditionRule(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean test(Map<String, Object> data, DynamicContext context, String activeExpr) {
        return true;
    }

    @Override
    public void executeRule(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder, String activeExpr, String ruleValue) throws SQLException {
        ParsedSql parsedSql = ParsedSql.getParsedSql(activeExpr);
        String buildSql = parsedSql.buildSql(new MapSqlParameterSource(data));
        Object[] objects = parsedSql.buildValues(new MapSqlParameterSource(data));
        ArrayList<SqlArg> argList = new ArrayList<SqlArg>(objects.length);
        boolean needExit = true;
        for (Object argData : objects) {
            SqlArg sqlArg = null;
            if (argData == null) {
                sqlArg = new SqlArg(ruleValue, null, SqlMode.In, 0, String.class, stringTypeHandler);
            } else {
                Class<?> argType = argData.getClass();
                int sqlType = TypeHandlerRegistry.toSqlType(argType);
                TypeHandler<?> typeHandler = context.getTypeRegistry().getTypeHandler(argType);
                sqlArg = new SqlArg("", argData, SqlMode.In, sqlType, argType, typeHandler);
                needExit = false;
            }
            argList.add(sqlArg);
        }
        if (needExit) {
            return;
        }
        String sql = sqlBuilder.getSqlString().toLowerCase();
        if (sql.contains("where")) {
            if (sql.trim().endsWith("where") || sql.trim().endsWith("and") || sql.trim().endsWith("or")) {
                sqlBuilder.appendSql(buildSql, argList.toArray());
            } else {
                sqlBuilder.appendSql(this.prefix + " " + buildSql, argList.toArray());
            }
        } else {
            sqlBuilder.appendSql("where " + buildSql, argList.toArray());
        }
    }
}

