/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.dynamic.nodes;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.db.dal.dynamic.DynamicContext;
import net.hasor.db.dal.dynamic.nodes.ArrayDynamicSql;
import net.hasor.db.dialect.SqlBuilder;

public class TrimDynamicSql
extends ArrayDynamicSql {
    private final String prefix;
    private final String suffix;
    private final String[] prefixOverrides;
    private final String[] suffixOverrides;

    public TrimDynamicSql(String prefix, String suffix, String prefixOverrides, String suffixOverrides) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.prefixOverrides = StringUtils.isBlank((String)prefixOverrides) ? ArrayUtils.EMPTY_STRING_ARRAY : (String[])Arrays.stream(prefixOverrides.split("\\|")).map(String::trim).toArray(String[]::new);
        this.suffixOverrides = StringUtils.isBlank((String)suffixOverrides) ? ArrayUtils.EMPTY_STRING_ARRAY : (String[])Arrays.stream(suffixOverrides.split("\\|")).map(String::trim).toArray(String[]::new);
    }

    private static boolean startsWith(String test, String prefix) {
        return StringUtils.startsWithIgnoreCase((String)test.trim(), (String)prefix);
    }

    private static boolean endsWith(String test, String suffix) {
        return StringUtils.endsWithIgnoreCase((String)test.trim(), (String)suffix);
    }

    @Override
    public void buildQuery(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder) throws SQLException {
        SqlBuilder tempDalSqlBuilder = new SqlBuilder();
        super.buildQuery(data, context, tempDalSqlBuilder);
        String childrenSql = tempDalSqlBuilder.getSqlString().trim();
        if (StringUtils.isNotBlank((String)childrenSql)) {
            if (!sqlBuilder.lastSpaceCharacter()) {
                sqlBuilder.appendSql(" ");
            }
            sqlBuilder.appendSql(StringUtils.defaultString((String)this.prefix) + " ");
            for (String override : this.prefixOverrides) {
                if (StringUtils.isBlank((String)(override = override.trim())) || !TrimDynamicSql.startsWith(childrenSql, override)) continue;
                childrenSql = childrenSql.substring(childrenSql.indexOf(override) + override.length());
                break;
            }
            for (String override : this.suffixOverrides) {
                if (!TrimDynamicSql.endsWith(childrenSql, override)) continue;
                childrenSql = childrenSql.substring(0, childrenSql.lastIndexOf(override));
                break;
            }
            sqlBuilder.appendSql(childrenSql);
            sqlBuilder.appendSql(" " + StringUtils.defaultString((String)this.suffix));
        }
        sqlBuilder.appendArgs(tempDalSqlBuilder);
    }
}

