/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Month;
import net.hasor.db.types.handler.AbstractTypeHandler;
import net.hasor.utils.NumberUtils;
import net.hasor.utils.StringUtils;

public class MonthOfStringTypeHandler
extends AbstractTypeHandler<Month> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Month month, JDBCType jdbcType) throws SQLException {
        ps.setString(i, month.name().toUpperCase());
    }

    @Override
    public Month getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String month = rs.getString(columnName);
        if (StringUtils.isBlank((String)month)) {
            return null;
        }
        return NumberUtils.isNumber((String)(month = month.trim().toUpperCase())) ? Month.of(Integer.parseInt(month)) : Month.valueOf(month);
    }

    @Override
    public Month getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String month = rs.getString(columnIndex);
        if (StringUtils.isBlank((String)month)) {
            return null;
        }
        return NumberUtils.isNumber((String)(month = month.trim().toUpperCase())) ? Month.of(Integer.parseInt(month)) : Month.valueOf(month);
    }

    @Override
    public Month getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String month = cs.getString(columnIndex);
        if (StringUtils.isBlank((String)month)) {
            return null;
        }
        return NumberUtils.isNumber((String)(month = month.trim().toUpperCase())) ? Month.of(Integer.parseInt(month)) : Month.valueOf(month);
    }
}

