/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.JapaneseDate;
import java.util.Date;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class JapaneseDateTypeHandler
extends AbstractTypeHandler<JapaneseDate> {
    public static JapaneseDate toJapaneseDate(java.sql.Date date) {
        if (date != null) {
            return JapaneseDate.from(date.toLocalDate());
        }
        return null;
    }

    public static JapaneseDate toJapaneseDate(Date date) {
        if (date != null) {
            return JapaneseDateTypeHandler.toJapaneseDate(new java.sql.Date(date.getTime()));
        }
        return null;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, JapaneseDate parameter, JDBCType jdbcType) throws SQLException {
        ps.setDate(i, java.sql.Date.valueOf(LocalDate.ofEpochDay(parameter.toEpochDay())));
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        java.sql.Date date = rs.getDate(columnName);
        return JapaneseDateTypeHandler.toJapaneseDate(date);
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        java.sql.Date date = rs.getDate(columnIndex);
        return JapaneseDateTypeHandler.toJapaneseDate(date);
    }

    @Override
    public JapaneseDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        java.sql.Date date = cs.getDate(columnIndex);
        return JapaneseDateTypeHandler.toJapaneseDate(date);
    }
}

