/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jsqlparser.expression;

import java.util.List;
import java.util.Objects;
import net.hasor.db.jsqlparser.statement.create.table.ColDataType;

public class Alias {
    private String name;
    private boolean useAs = true;
    private List<AliasColumn> aliasColumns;

    public Alias(String name) {
        this.name = name;
    }

    public Alias(String name, boolean useAs) {
        this.name = name;
        this.useAs = useAs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUseAs() {
        return this.useAs;
    }

    public void setUseAs(boolean useAs) {
        this.useAs = useAs;
    }

    public List<AliasColumn> getAliasColumns() {
        return this.aliasColumns;
    }

    public void setAliasColumns(List<AliasColumn> aliasColumns) {
        this.aliasColumns = aliasColumns;
    }

    public String toString() {
        String alias = (this.useAs ? " AS " : " ") + this.name;
        if (this.aliasColumns != null && !this.aliasColumns.isEmpty()) {
            String ac = "";
            for (AliasColumn col : this.aliasColumns) {
                if (ac.length() > 0) {
                    ac = ac + ", ";
                }
                ac = ac + col.name;
                if (col.colDataType == null) continue;
                ac = ac + " " + col.colDataType.toString();
            }
            alias = alias + "(" + ac + ")";
        }
        return alias;
    }

    public static class AliasColumn {
        public final String name;
        public final ColDataType colDataType;

        public AliasColumn(String name, ColDataType colDataType) {
            Objects.requireNonNull(name);
            this.name = name;
            this.colDataType = colDataType;
        }

        public AliasColumn(String name) {
            this(name, null);
        }
    }
}

