/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.lambda.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.hasor.db.dal.orm.FieldInfo;
import net.hasor.db.dal.orm.TableInfo;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.lambda.LambdaOperations;
import net.hasor.db.jdbc.lambda.query.AbstractCompareQuery;
import net.hasor.db.jdbc.lambda.segment.MergeSqlSegment;
import net.hasor.db.jdbc.lambda.segment.OrderByKeyword;
import net.hasor.db.jdbc.lambda.segment.Segment;
import net.hasor.db.jdbc.lambda.segment.SqlKeyword;
import net.hasor.db.jdbc.page.Page;
import net.hasor.utils.reflect.SFunction;

public class LambdaQueryWrapper<T>
extends AbstractCompareQuery<T, LambdaOperations.LambdaQuery<T>>
implements LambdaOperations.LambdaQuery<T> {
    private final List<Segment> customSelect = new ArrayList<Segment>();
    private final List<Segment> groupBySegments = new ArrayList<Segment>();
    private final List<Segment> orderBySegments = new ArrayList<Segment>();
    private boolean lockGroupBy = false;
    private boolean lockOrderBy = false;
    private String result = null;

    public LambdaQueryWrapper(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        super(exampleType, jdbcTemplate);
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        return new BoundSql(){

            @Override
            public String getSqlString() {
                return LambdaQueryWrapper.this.oriSqlString();
            }

            @Override
            public Object[] getArgs() {
                return LambdaQueryWrapper.this.oriArgs();
            }
        };
    }

    private String oriSqlString() {
        if (this.result != null) {
            return this.result;
        }
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        sqlSegment.addSegment(SqlKeyword.SELECT);
        sqlSegment.addSegment(LambdaQueryWrapper.buildColumns(this.groupBySegments.isEmpty() ? this.customSelect : this.groupBySegments));
        sqlSegment.addSegment(SqlKeyword.FROM);
        sqlSegment.addSegment(this.buildTabName(this.dialect()));
        if (!this.queryTemplate.isEmpty()) {
            sqlSegment.addSegment(SqlKeyword.WHERE);
            sqlSegment.addSegment(this.queryTemplate.sub(1));
        }
        this.result = sqlSegment.getSqlSegment();
        return this.result;
    }

    private Object[] oriArgs() {
        return (Object[])this.queryParam.toArray().clone();
    }

    private Segment buildTabName(SqlDialect dialect) {
        TableInfo tableInfo = super.getRowMapper().getTableInfo();
        if (tableInfo == null) {
            throw new IllegalArgumentException("tableInfo not found.");
        }
        return () -> dialect.buildTableName(tableInfo.getCategory(), tableInfo.getTableName());
    }

    private static Segment buildColumns(Collection<Segment> columnSegments) {
        if (columnSegments.isEmpty()) {
            return SqlKeyword.COLUMNS;
        }
        return LambdaQueryWrapper.buildBySeparator(columnSegments, ",");
    }

    private static Segment buildBySeparator(Collection<Segment> orderBySegments, String separator) {
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Segment> columnIterator = orderBySegments.iterator();
        while (columnIterator.hasNext()) {
            Segment entry = columnIterator.next();
            sqlSegment.addSegment(entry);
            if (!columnIterator.hasNext()) continue;
            sqlSegment.addSegment(() -> separator);
        }
        return sqlSegment;
    }

    protected void lockGroupBy() {
        this.lockCondition();
        this.lockGroupBy = true;
    }

    protected void lockOrderBy() {
        this.lockGroupBy();
        this.lockOrderBy = true;
    }

    @Override
    protected LambdaOperations.LambdaQuery<T> getSelf() {
        return this;
    }

    @Override
    public LambdaOperations.LambdaQuery<T> selectAll() {
        this.customSelect.clear();
        return this;
    }

    @Override
    public LambdaOperations.LambdaQuery<T> select(String ... columns) {
        if (columns != null && columns.length > 0) {
            this.customSelect.addAll(Arrays.stream(columns).map(s -> () -> s).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public final LambdaOperations.LambdaQuery<T> select(List<SFunction<T>> columns) {
        List<FieldInfo> selectColumn = columns.stream().filter(Objects::nonNull).map(this::columnName).collect(Collectors.toList());
        return this.select0(selectColumn, fieldInfo -> true);
    }

    @Override
    public final LambdaOperations.LambdaQuery<T> select(Predicate<FieldInfo> tester) {
        Collection<FieldInfo> allFiled = super.getRowMapper().allFieldInfoByProperty();
        return this.select0(allFiled, tester);
    }

    private LambdaOperations.LambdaQuery<T> select0(Collection<FieldInfo> allFiled, Predicate<FieldInfo> tester) {
        TableInfo tableInfo = super.getRowMapper().getTableInfo();
        allFiled.stream().filter(tester).forEach(fieldInfo -> {
            String selectColumn = this.dialect().buildSelect(tableInfo.getCategory(), tableInfo.getTableName(), fieldInfo.getColumnName(), fieldInfo.getJdbcType(), fieldInfo.getJavaType());
            this.customSelect.add(() -> selectColumn);
        });
        return this;
    }

    @Override
    public final LambdaOperations.LambdaQuery<T> groupBy(List<SFunction<T>> columns) {
        if (this.lockGroupBy) {
            throw new IllegalStateException("group by is locked.");
        }
        this.lockCondition();
        if (columns != null && !columns.isEmpty()) {
            if (this.groupBySegments.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.GROUP_BY);
            }
            ArrayList<Segment> groupBySeg = new ArrayList<Segment>();
            for (SFunction<T> fun : columns) {
                groupBySeg.add(() -> this.conditionName(fun));
            }
            this.groupBySegments.addAll(groupBySeg);
            this.queryTemplate.addSegment(LambdaQueryWrapper.buildBySeparator(groupBySeg, ","));
        }
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> orderBy(List<SFunction<T>> columns) {
        return this.addOrderBy(OrderByKeyword.ORDER_DEFAULT, columns);
    }

    @Override
    public LambdaOperations.LambdaQuery<T> asc(List<SFunction<T>> columns) {
        return this.addOrderBy(OrderByKeyword.ASC, columns);
    }

    @Override
    public LambdaOperations.LambdaQuery<T> desc(List<SFunction<T>> columns) {
        return this.addOrderBy(OrderByKeyword.DESC, columns);
    }

    private LambdaOperations.LambdaQuery<T> addOrderBy(OrderByKeyword keyword, List<SFunction<T>> orderBy) {
        if (this.lockOrderBy) {
            throw new IllegalStateException("order by is locked.");
        }
        this.lockGroupBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            if (this.orderBySegments.isEmpty()) {
                this.queryTemplate.addSegment(SqlKeyword.ORDER_BY);
            } else {
                this.queryTemplate.addSegment(() -> ",");
            }
            ArrayList<Segment> orderBySeg = new ArrayList<Segment>();
            for (SFunction<T> fun : orderBy) {
                MergeSqlSegment orderByItem = new MergeSqlSegment(() -> this.conditionName(fun), keyword);
                orderBySeg.add(orderByItem);
            }
            this.orderBySegments.addAll(orderBySeg);
            this.queryTemplate.addSegment(LambdaQueryWrapper.buildBySeparator(orderBySeg, ","));
        }
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> usePage(Page pageInfo) {
        Page page = this.pageInfo();
        page.setPageSize(pageInfo.getPageSize());
        page.setCurrentPage(pageInfo.getCurrentPage());
        page.setPageNumberOffset(pageInfo.getPageNumberOffset());
        return this.getSelf();
    }

    @Override
    public LambdaOperations.LambdaQuery<T> initPage(int pageSize, int pageNumber) {
        Page pageInfo = this.pageInfo();
        pageInfo.setPageNumberOffset(0);
        pageInfo.setPageSize(pageSize);
        pageInfo.setCurrentPage(pageNumber);
        return this.getSelf();
    }
}

