/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.lambda.query;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.db.JdbcUtils;
import net.hasor.db.dal.orm.MappingRowMapper;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.dialect.SqlDialectRegister;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.lambda.QueryExecute;
import net.hasor.db.jdbc.page.Page;
import net.hasor.db.jdbc.page.PageObject;
import net.hasor.utils.function.ESupplier;

public abstract class AbstractQueryExecute<T>
implements QueryExecute<T> {
    protected final String dbType;
    private final SqlDialect dialect;
    private final Class<T> exampleType;
    private final MappingRowMapper<T> exampleRowMapper;
    private final JdbcOperations jdbcOperations;
    private boolean useDialect;
    private final Page pageInfo = new PageObject(0, (ESupplier<Integer, SQLException>)((ESupplier)this::queryForCount));

    public AbstractQueryExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        String tmpDbType;
        this.exampleType = exampleType;
        this.jdbcOperations = jdbcTemplate;
        this.exampleRowMapper = jdbcTemplate != null ? jdbcTemplate.getMappingHandler().resolveMapper(exampleType) : MappingRowMapper.newInstance(exampleType);
        try {
            tmpDbType = this.getJdbcOperations().execute(con -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        SqlDialect tempDialect = SqlDialectRegister.findOrCreate(tmpDbType);
        this.dbType = tmpDbType;
        this.dialect = tempDialect == null ? SqlDialect.DEFAULT : tempDialect;
        this.useDialect = false;
    }

    AbstractQueryExecute(Class<T> exampleType, JdbcOperations jdbcOperations, String dbType, SqlDialect dialect) {
        this.exampleType = exampleType;
        this.jdbcOperations = jdbcOperations;
        this.exampleRowMapper = jdbcOperations instanceof JdbcTemplate ? ((JdbcTemplate)jdbcOperations).getMappingHandler().resolveMapper(exampleType) : MappingRowMapper.newInstance(exampleType);
        this.dbType = dbType;
        this.dialect = dialect == null ? SqlDialect.DEFAULT : dialect;
    }

    @Override
    public Class<T> exampleType() {
        return this.exampleType;
    }

    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    protected MappingRowMapper<T> getRowMapper() {
        return this.exampleRowMapper;
    }

    protected SqlDialect dialect() {
        return this.useDialect && this.dialect != null ? this.dialect : SqlDialect.DEFAULT;
    }

    public final BoundSql getBoundSql(SqlDialect dialect) {
        int pageSize = this.pageInfo.getPageSize();
        if (pageSize > 0) {
            int recordPosition = this.pageInfo.getFirstRecordPosition();
            return dialect.getPageSql(this.getOriginalBoundSql(), recordPosition, pageSize);
        }
        return this.getOriginalBoundSql();
    }

    public final BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect);
    }

    protected abstract BoundSql getOriginalBoundSql();

    public Page pageInfo() {
        return this.pageInfo;
    }

    @Override
    public <V> QueryExecute<V> wrapperType(Class<V> wrapperType) {
        final AbstractQueryExecute self = this;
        return new AbstractQueryExecute<V>(wrapperType, this.jdbcOperations, this.dbType, this.dialect){

            @Override
            protected BoundSql getOriginalBoundSql() {
                return self.getOriginalBoundSql();
            }
        };
    }

    @Override
    public <V> V query(ResultSetExtractor<V> rse) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.query(boundSql.getSqlString(), boundSql.getArgs(), rse);
    }

    @Override
    public void query(RowCallbackHandler rch) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        this.jdbcOperations.query(boundSql.getSqlString(), boundSql.getArgs(), rch);
    }

    @Override
    public <V> List<V> query(RowMapper<V> rowMapper) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.query(boundSql.getSqlString(), boundSql.getArgs(), rowMapper);
    }

    @Override
    public List<T> queryForList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.query(boundSql.getSqlString(), boundSql.getArgs(), this.getRowMapper());
    }

    @Override
    public T queryForObject() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.queryForObject(boundSql.getSqlString(), boundSql.getArgs(), this.getRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.queryForMap(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public List<Map<String, Object>> queryForMapList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.jdbcOperations.queryForList(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public int queryForCount() throws SQLException {
        BoundSql countSql = this.dialect.getCountSql(this.getOriginalBoundSql());
        return this.jdbcOperations.queryForInt(countSql.getSqlString(), countSql.getArgs());
    }

    @Override
    public long queryForLargeCount() throws SQLException {
        BoundSql countSql = this.dialect.getCountSql(this.getOriginalBoundSql());
        return this.jdbcOperations.queryForLong(countSql.getSqlString(), countSql.getArgs());
    }
}

