/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jsqlparser.JSQLParserException;
import net.hasor.db.jsqlparser.parser.CCJSqlParserUtil;
import net.hasor.db.jsqlparser.statement.select.OrderByElement;
import net.hasor.db.jsqlparser.statement.select.PlainSelect;
import net.hasor.db.jsqlparser.statement.select.Select;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;

public class SqlServerDialect
implements SqlDialect {
    private static final Map<String, Select> CACHE = new WeakHashMap<String, Select>();
    private static final Object LOCK_OBJECT = new Object();

    protected static Select parseSelect(String buildSqlString) {
        Select select = CACHE.get(buildSqlString);
        if (select != null) {
            return select;
        }
        Object object = LOCK_OBJECT;
        synchronized (object) {
            select = CACHE.get(buildSqlString);
            if (select != null) {
                return select;
            }
            try {
                select = (Select)CCJSqlParserUtil.parse(buildSqlString);
                CACHE.put(buildSqlString, select);
                return select;
            }
            catch (JSQLParserException e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public String buildSelect(String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        return "[" + columnName + "]";
    }

    @Override
    public String buildTableName(String category, String tableName) {
        if (StringUtils.isBlank((String)category)) {
            return "[" + tableName + "]";
        }
        return "[" + category + "].[" + tableName + "]";
    }

    @Override
    public String buildColumnName(String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        return "[" + columnName + "]";
    }

    @Override
    public BoundSql getCountSql(BoundSql boundSql) {
        Select selectStatement;
        PlainSelect plainSelect;
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (sqlString.toLowerCase().contains("order by") && (plainSelect = (PlainSelect)(selectStatement = SqlServerDialect.parseSelect(sqlString)).getSelectBody()).getOrderByElements() != null) {
            List<OrderByElement> orderByElements = plainSelect.getOrderByElements();
            plainSelect.setOrderByElements(null);
            sqlString = selectStatement.toString();
            plainSelect.setOrderByElements(orderByElements);
        }
        String sqlBuilder = "SELECT COUNT(*) FROM (" + sqlString + ") as TEMP_T";
        return new BoundSql.BoundSqlObj(sqlBuilder, paramArrays.toArray());
    }

    @Override
    public BoundSql getPageSql(BoundSql boundSql, int start, int limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(sqlString);
        if (sqlString.toLowerCase().contains("order by")) {
            Select selectStatement = SqlServerDialect.parseSelect(sqlString);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            if (plainSelect.getOrderByElements() == null) {
                sqlBuilder.append(" ORDER BY CURRENT_TIMESTAMP");
            }
        } else {
            sqlBuilder.append(" ORDER BY CURRENT_TIMESTAMP");
        }
        sqlBuilder.append(" offset ? rows fetch next ? rows only");
        paramArrays.add(start);
        paramArrays.add(limit);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }
}

