/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.utils.StringUtils;

public class InformixDialect
implements SqlDialect {
    @Override
    public String buildSelect(String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        return "\"" + columnName + "\"";
    }

    @Override
    public String buildTableName(String category, String tableName) {
        if (StringUtils.isBlank((String)category)) {
            return "\"" + tableName + "\"";
        }
        return "\"" + category + "\".\"" + tableName + "\"";
    }

    @Override
    public String buildColumnName(String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        return "\"" + columnName + "\"";
    }

    @Override
    public BoundSql getPageSql(BoundSql boundSql, int start, int limit) {
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Integer> newParam = new ArrayList<Integer>();
        sqlBuilder.append("SELECT ");
        if (start > 0) {
            sqlBuilder.append(" SKIP ? ");
            newParam.add(start);
        }
        if (limit > 0) {
            sqlBuilder.append(" FIRST ? ");
            newParam.add(limit);
        }
        sqlBuilder.append(" * FROM ( ");
        sqlBuilder.append(boundSql.getSqlString());
        sqlBuilder.append(" ) TEMP_T");
        paramArrays.addAll(0, newParam);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }
}

