/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.orm;

import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hasor.db.dal.orm.Field;
import net.hasor.db.dal.orm.FieldImpl;
import net.hasor.db.dal.orm.FieldInfo;
import net.hasor.db.dal.orm.FieldInfoImpl;
import net.hasor.db.dal.orm.MappingHandler;
import net.hasor.db.dal.orm.Table;
import net.hasor.db.dal.orm.TableImpl;
import net.hasor.db.dal.orm.TableInfo;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import net.hasor.db.types.UnknownTypeHandler;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;

public class MappingRowMapper<T>
implements RowMapper<T>,
TableInfo {
    private final Class<T> mapperClass;
    private String category;
    private String tableName;
    private boolean caseInsensitive;
    private final Map<String, String> propertyColumnMapping;
    private final Map<String, String> columnPropertyMapping;
    private final List<String> columnNames;
    private final Map<String, FieldInfo> columnFieldInfoMap;
    private final Map<String, TypeHandler<?>> columnTypeHandlerMap;

    public MappingRowMapper(Class<T> mapperClass) {
        this(mapperClass, TypeHandlerRegistry.DEFAULT);
    }

    public MappingRowMapper(Class<T> mapperClass, TypeHandlerRegistry handlerRegistry) {
        this.mapperClass = mapperClass;
        this.columnNames = new ArrayList<String>();
        this.columnFieldInfoMap = new HashMap<String, FieldInfo>();
        this.columnTypeHandlerMap = new HashMap();
        this.propertyColumnMapping = new HashMap<String, String>();
        this.columnPropertyMapping = new HashMap<String, String>();
        this.initialize(mapperClass, Objects.requireNonNull(handlerRegistry, "handlerRegistry is null."));
    }

    private void initialize(Class<T> mapperClass, TypeHandlerRegistry registry) {
        Table defTable = null;
        defTable = mapperClass.isAnnotationPresent(Table.class) ? mapperClass.getAnnotation(Table.class) : new TableImpl("", mapperClass.getSimpleName());
        this.tableName = defTable.category().trim();
        this.tableName = StringUtils.isNotBlank((String)defTable.name()) ? defTable.name() : defTable.value();
        this.caseInsensitive = defTable.caseInsensitive();
        boolean autoConfigField = defTable.autoFiled();
        List allFields = BeanUtils.findALLFields(mapperClass);
        for (java.lang.reflect.Field field : allFields) {
            Field defField = this.defField(field, autoConfigField);
            if (defField == null) continue;
            TypeHandler<?> typeHandler = null;
            if (defField.typeHandler() == UnknownTypeHandler.class) {
                typeHandler = registry.getTypeHandler(field.getType(), defField.jdbcType());
            } else {
                try {
                    typeHandler = defField.typeHandler().newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e);
                }
            }
            this.setupField(field, defField, typeHandler);
        }
    }

    private Field defField(java.lang.reflect.Field dtoField, boolean autoConfigField) {
        if (dtoField.isAnnotationPresent(Field.class)) {
            return dtoField.getAnnotation(Field.class);
        }
        if (autoConfigField) {
            Class<?> fieldType = dtoField.getType();
            JDBCType jdbcType = TypeHandlerRegistry.toSqlType(fieldType);
            return new FieldImpl(dtoField.getName(), jdbcType);
        }
        return null;
    }

    private void setupField(java.lang.reflect.Field property, Field defField, TypeHandler<?> toTypeHandler) {
        String columnName = null;
        JDBCType jdbcType = defField.jdbcType();
        columnName = StringUtils.isNotBlank((String)defField.name()) ? defField.name() : defField.value();
        if (StringUtils.isBlank((String)columnName)) {
            columnName = property.getName();
        }
        if (jdbcType == JDBCType.OTHER) {
            jdbcType = TypeHandlerRegistry.toSqlType(property.getType());
        }
        String useColumnName = columnName;
        if (this.caseInsensitive) {
            useColumnName = useColumnName.toUpperCase();
        }
        this.columnNames.add(useColumnName);
        this.columnFieldInfoMap.put(useColumnName, new FieldInfoImpl(columnName, jdbcType, property.getType()));
        this.columnTypeHandlerMap.put(useColumnName, toTypeHandler);
        this.columnPropertyMapping.put(useColumnName, property.getName());
        this.propertyColumnMapping.put(property.getName(), useColumnName);
    }

    public Class<T> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public FieldInfo findFieldInfoByProperty(String propertyName) {
        String columnName = this.propertyColumnMapping.get(propertyName);
        return this.columnFieldInfoMap.get(columnName);
    }

    public Collection<FieldInfo> allFieldInfoByProperty() {
        return this.columnFieldInfoMap.values();
    }

    public TableInfo getTableInfo() {
        return this;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            T targetObject = this.mapperClass.newInstance();
            return this.tranResultSet(rs, targetObject);
        }
        catch (ReflectiveOperationException e) {
            throw new SQLException(e);
        }
    }

    private T tranResultSet(ResultSet rs, T targetObject) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        HashMap<String, Integer> resultColumnMap = new HashMap<String, Integer>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            String colName = rsmd.getColumnName(i);
            if (this.caseInsensitive) {
                resultColumnMap.put(colName.toUpperCase(), i);
                continue;
            }
            resultColumnMap.put(colName, i);
        }
        for (String columnName : this.columnNames) {
            if (!resultColumnMap.containsKey(columnName)) continue;
            int realIndex = (Integer)resultColumnMap.get(columnName);
            TypeHandler<?> realHandler = this.columnTypeHandlerMap.get(columnName);
            Object result = realHandler.getResult(rs, realIndex);
            String propertyName = this.columnPropertyMapping.get(columnName);
            Class propertyType = BeanUtils.getPropertyOrFieldType(this.mapperClass, (String)propertyName);
            Object convert = ConverterUtils.convert((Class)propertyType, result);
            BeanUtils.writePropertyOrField(targetObject, (String)propertyName, (Object)convert);
        }
        return targetObject;
    }

    public static <T> MappingRowMapper<T> newInstance(Class<T> mappedClass) {
        return MappingHandler.DEFAULT.resolveMapper(mappedClass);
    }

    public static <T> MappingRowMapper<T> newInstance(Class<T> mappedClass, TypeHandlerRegistry registry) {
        return new MappingHandler(registry).resolveMapper(mappedClass);
    }
}

