/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dal.orm;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.db.dal.orm.MappingRowMapper;
import net.hasor.db.types.TypeHandlerRegistry;

public class MappingHandler {
    public static final MappingHandler DEFAULT = new MappingHandler(TypeHandlerRegistry.DEFAULT);
    protected final TypeHandlerRegistry typeRegistry;
    protected final Map<Class<?>, MappingRowMapper<?>> resultMapperMap;

    public MappingHandler(TypeHandlerRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry not null.");
        this.resultMapperMap = new ConcurrentHashMap();
    }

    public TypeHandlerRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MappingRowMapper<T> resolveMapper(Class<T> dtoClass) {
        MappingRowMapper<Object> resultMapper = this.resultMapperMap.get(dtoClass);
        if (resultMapper == null) {
            MappingHandler mappingHandler = this;
            synchronized (mappingHandler) {
                resultMapper = this.resultMapperMap.get(dtoClass);
                if (resultMapper != null) {
                    return resultMapper;
                }
                resultMapper = new MappingRowMapper<T>(dtoClass);
                this.resultMapperMap.put(dtoClass, resultMapper);
            }
        }
        return resultMapper;
    }
}

