/*
 * Copyright 2002-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.db.dal.orm;
import java.sql.JDBCType;

/**
 * 字段 or 列 信息
 * @version : 2020-10-31
 * @author 赵永春 (zyc@hasor.net)
 */
class FieldInfoImpl implements FieldInfo {
    private final String   columnName;
    private final JDBCType jdbcType;
    private final Class<?> javaType;

    public FieldInfoImpl(String columnName, JDBCType jdbcType, Class<?> javaType) {
        this.columnName = columnName;
        this.jdbcType = jdbcType;
        this.javaType = javaType;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }
}
