/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class NClobTypeHandler
extends AbstractTypeHandler<String> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JDBCType jdbcType) throws SQLException {
        ps.setNClob(i, new StringReader(parameter));
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        NClob clob = rs.getNClob(columnName);
        return this.toString(clob);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        NClob clob = rs.getNClob(columnIndex);
        return this.toString(clob);
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        NClob clob = cs.getNClob(columnIndex);
        return this.toString(clob);
    }

    private String toString(NClob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        try {
            String string = clob.getSubString(1L, (int)clob.length());
            return string;
        }
        finally {
            clob.free();
        }
    }
}

