/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class BytesForWrapTypeHandler
extends AbstractTypeHandler<Byte[]> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Byte[] parameter, JDBCType jdbcType) throws SQLException {
        ps.setBytes(i, BytesForWrapTypeHandler.convertToPrimitiveArray(parameter));
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] bytes = rs.getBytes(columnName);
        return this.getBytes(bytes);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] bytes = rs.getBytes(columnIndex);
        return this.getBytes(bytes);
    }

    @Override
    public Byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] bytes = cs.getBytes(columnIndex);
        return this.getBytes(bytes);
    }

    private Byte[] getBytes(byte[] bytes) {
        Byte[] returnValue = null;
        if (bytes != null) {
            returnValue = BytesForWrapTypeHandler.convertToObjectArray(bytes);
        }
        return returnValue;
    }

    private static byte[] convertToPrimitiveArray(Byte[] objects) {
        byte[] bytes = new byte[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            bytes[i] = objects[i];
        }
        return bytes;
    }

    private static Byte[] convertToObjectArray(byte[] bytes) {
        Byte[] objects = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            objects[i] = bytes[i];
        }
        return objects;
    }
}

