/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.db.types.MappedCross;
import net.hasor.db.types.MappedJavaTypes;
import net.hasor.db.types.MappedJdbcTypes;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.UnknownTypeHandler;
import net.hasor.db.types.handler.ArrayTypeHandler;
import net.hasor.db.types.handler.BigDecimalTypeHandler;
import net.hasor.db.types.handler.BigIntegerTypeHandler;
import net.hasor.db.types.handler.BlobBytesForWrapTypeHandler;
import net.hasor.db.types.handler.BlobBytesTypeHandler;
import net.hasor.db.types.handler.BlobInputStreamTypeHandler;
import net.hasor.db.types.handler.BooleanTypeHandler;
import net.hasor.db.types.handler.ByteTypeHandler;
import net.hasor.db.types.handler.BytesForWrapTypeHandler;
import net.hasor.db.types.handler.BytesInputStreamTypeHandler;
import net.hasor.db.types.handler.BytesTypeHandler;
import net.hasor.db.types.handler.CharacterTypeHandler;
import net.hasor.db.types.handler.ClobReaderTypeHandler;
import net.hasor.db.types.handler.ClobTypeHandler;
import net.hasor.db.types.handler.DateOnlyTypeHandler;
import net.hasor.db.types.handler.DateTypeHandler;
import net.hasor.db.types.handler.DoubleTypeHandler;
import net.hasor.db.types.handler.EnumTypeHandler;
import net.hasor.db.types.handler.FloatTypeHandler;
import net.hasor.db.types.handler.InstantTypeHandler;
import net.hasor.db.types.handler.IntegerTypeHandler;
import net.hasor.db.types.handler.JapaneseDateTypeHandler;
import net.hasor.db.types.handler.LocalDateTimeTypeHandler;
import net.hasor.db.types.handler.LocalDateTypeHandler;
import net.hasor.db.types.handler.LocalTimeTypeHandler;
import net.hasor.db.types.handler.LongTypeHandler;
import net.hasor.db.types.handler.MonthDayOfNumberTypeHandler;
import net.hasor.db.types.handler.MonthDayOfStringTypeHandler;
import net.hasor.db.types.handler.MonthDayOfTimeTypeHandler;
import net.hasor.db.types.handler.MonthOfNumberTypeHandler;
import net.hasor.db.types.handler.MonthOfStringTypeHandler;
import net.hasor.db.types.handler.MonthOfTimeTypeHandler;
import net.hasor.db.types.handler.NCharacterTypeHandler;
import net.hasor.db.types.handler.NClobReaderTypeHandler;
import net.hasor.db.types.handler.NClobTypeHandler;
import net.hasor.db.types.handler.NStringReaderTypeHandler;
import net.hasor.db.types.handler.NStringTypeHandler;
import net.hasor.db.types.handler.NumberTypeHandler;
import net.hasor.db.types.handler.ObjectTypeHandler;
import net.hasor.db.types.handler.OffsetDateTimeForSqlTypeHandler;
import net.hasor.db.types.handler.OffsetDateTimeForUTCTypeHandler;
import net.hasor.db.types.handler.OffsetTimeForSqlTypeHandler;
import net.hasor.db.types.handler.OffsetTimeForUTCTypeHandler;
import net.hasor.db.types.handler.ShortTypeHandler;
import net.hasor.db.types.handler.SqlDateTypeHandler;
import net.hasor.db.types.handler.SqlTimeTypeHandler;
import net.hasor.db.types.handler.SqlTimestampTypeHandler;
import net.hasor.db.types.handler.SqlXmlForInputStreamTypeHandler;
import net.hasor.db.types.handler.SqlXmlForReaderTypeHandler;
import net.hasor.db.types.handler.SqlXmlTypeHandler;
import net.hasor.db.types.handler.StringReaderTypeHandler;
import net.hasor.db.types.handler.StringTypeHandler;
import net.hasor.db.types.handler.TimeOnlyTypeHandler;
import net.hasor.db.types.handler.YearMonthOfNumberTypeHandler;
import net.hasor.db.types.handler.YearMonthOfStringTypeHandler;
import net.hasor.db.types.handler.YearMonthOfTimeTypeHandler;
import net.hasor.db.types.handler.YearOfNumberTypeHandler;
import net.hasor.db.types.handler.YearOfStringTypeHandler;
import net.hasor.db.types.handler.YearOfTimeTypeHandler;
import net.hasor.db.types.handler.ZonedDateTimeTypeHandler;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.reflect.TypeReference;

public final class TypeHandlerRegistry {
    private static final Map<Type, TypeHandler<?>> cachedSingleHandlers = new ConcurrentHashMap();
    public static final TypeHandlerRegistry DEFAULT = new TypeHandlerRegistry();
    private static final Map<Class<?>, JDBCType> javaTypeToSqlTypeMap = new ConcurrentHashMap();
    private static final Map<JDBCType, Class<?>> jdbcTypeToJavaTypeMap = new ConcurrentHashMap();
    private final Map<Type, TypeHandler<?>> javaTypeHandlerMap = new ConcurrentHashMap();
    private final Map<JDBCType, TypeHandler<?>> jdbcTypeHandlerMap = new ConcurrentHashMap();
    private final Map<Type, Map<JDBCType, TypeHandler<?>>> typeHandlerMap = new ConcurrentHashMap();
    private final UnknownTypeHandler defaultTypeHandler = new UnknownTypeHandler(this);

    public TypeHandlerRegistry() {
        this.register((Type)((Object)Boolean.class), TypeHandlerRegistry.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(Boolean.TYPE, TypeHandlerRegistry.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register((Type)((Object)Byte.class), TypeHandlerRegistry.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(Byte.TYPE, TypeHandlerRegistry.createSingleTypeHandler(ByteTypeHandler.class));
        this.register((Type)((Object)Short.class), TypeHandlerRegistry.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(Short.TYPE, TypeHandlerRegistry.createSingleTypeHandler(ShortTypeHandler.class));
        this.register((Type)((Object)Integer.class), TypeHandlerRegistry.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(Integer.TYPE, TypeHandlerRegistry.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register((Type)((Object)Long.class), TypeHandlerRegistry.createSingleTypeHandler(LongTypeHandler.class));
        this.register(Long.TYPE, TypeHandlerRegistry.createSingleTypeHandler(LongTypeHandler.class));
        this.register((Type)((Object)Float.class), TypeHandlerRegistry.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(Float.TYPE, TypeHandlerRegistry.createSingleTypeHandler(FloatTypeHandler.class));
        this.register((Type)((Object)Double.class), TypeHandlerRegistry.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(Double.TYPE, TypeHandlerRegistry.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register((Type)((Object)Character.class), TypeHandlerRegistry.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register(Character.TYPE, TypeHandlerRegistry.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register((Type)((Object)Date.class), TypeHandlerRegistry.createSingleTypeHandler(DateTypeHandler.class));
        this.register((Type)((Object)java.sql.Date.class), TypeHandlerRegistry.createSingleTypeHandler(SqlDateTypeHandler.class));
        this.register((Type)((Object)Timestamp.class), TypeHandlerRegistry.createSingleTypeHandler(SqlTimestampTypeHandler.class));
        this.register((Type)((Object)Time.class), TypeHandlerRegistry.createSingleTypeHandler(SqlTimeTypeHandler.class));
        this.register((Type)((Object)Instant.class), TypeHandlerRegistry.createSingleTypeHandler(InstantTypeHandler.class));
        this.register((Type)((Object)JapaneseDate.class), TypeHandlerRegistry.createSingleTypeHandler(JapaneseDateTypeHandler.class));
        this.register((Type)((Object)Year.class), TypeHandlerRegistry.createSingleTypeHandler(YearOfTimeTypeHandler.class));
        this.register((Type)((Object)Month.class), TypeHandlerRegistry.createSingleTypeHandler(MonthOfTimeTypeHandler.class));
        this.register((Type)((Object)YearMonth.class), TypeHandlerRegistry.createSingleTypeHandler(YearMonthOfTimeTypeHandler.class));
        this.register((Type)((Object)MonthDay.class), TypeHandlerRegistry.createSingleTypeHandler(MonthDayOfTimeTypeHandler.class));
        this.register((Type)((Object)LocalDate.class), TypeHandlerRegistry.createSingleTypeHandler(LocalDateTypeHandler.class));
        this.register((Type)((Object)LocalTime.class), TypeHandlerRegistry.createSingleTypeHandler(LocalTimeTypeHandler.class));
        this.register((Type)((Object)LocalDateTime.class), TypeHandlerRegistry.createSingleTypeHandler(LocalDateTimeTypeHandler.class));
        this.register((Type)((Object)ZonedDateTime.class), TypeHandlerRegistry.createSingleTypeHandler(ZonedDateTimeTypeHandler.class));
        this.register((Type)((Object)OffsetDateTime.class), TypeHandlerRegistry.createSingleTypeHandler(OffsetDateTimeForUTCTypeHandler.class));
        this.register((Type)((Object)OffsetTime.class), TypeHandlerRegistry.createSingleTypeHandler(OffsetTimeForUTCTypeHandler.class));
        this.register((Type)((Object)String.class), TypeHandlerRegistry.createSingleTypeHandler(StringTypeHandler.class));
        this.register((Type)((Object)BigInteger.class), TypeHandlerRegistry.createSingleTypeHandler(BigIntegerTypeHandler.class));
        this.register((Type)((Object)BigDecimal.class), TypeHandlerRegistry.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register((Type)((Object)Reader.class), TypeHandlerRegistry.createSingleTypeHandler(StringReaderTypeHandler.class));
        this.register((Type)((Object)InputStream.class), TypeHandlerRegistry.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.register((Type)((Object)Byte[].class), TypeHandlerRegistry.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.register((Type)((Object)byte[].class), TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.register((Type)((Object)Object[].class), TypeHandlerRegistry.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register((Type)((Object)Object.class), TypeHandlerRegistry.createSingleTypeHandler(UnknownTypeHandler.class));
        this.register((Type)((Object)Number.class), TypeHandlerRegistry.createSingleTypeHandler(NumberTypeHandler.class));
        this.register((Type)((Object)Clob.class), TypeHandlerRegistry.createSingleTypeHandler(ClobTypeHandler.class));
        this.register((Type)((Object)NClob.class), TypeHandlerRegistry.createSingleTypeHandler(NClobTypeHandler.class));
        this.register((Type)((Object)Blob.class), TypeHandlerRegistry.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.register(JDBCType.BIT, TypeHandlerRegistry.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(JDBCType.BOOLEAN, TypeHandlerRegistry.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(JDBCType.TINYINT, TypeHandlerRegistry.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(JDBCType.SMALLINT, TypeHandlerRegistry.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(JDBCType.INTEGER, TypeHandlerRegistry.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(JDBCType.BIGINT, TypeHandlerRegistry.createSingleTypeHandler(LongTypeHandler.class));
        this.register(JDBCType.FLOAT, TypeHandlerRegistry.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(JDBCType.DOUBLE, TypeHandlerRegistry.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(JDBCType.REAL, TypeHandlerRegistry.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.NUMERIC, TypeHandlerRegistry.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.DECIMAL, TypeHandlerRegistry.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.CHAR, TypeHandlerRegistry.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register(JDBCType.NCHAR, TypeHandlerRegistry.createSingleTypeHandler(NCharacterTypeHandler.class));
        this.register(JDBCType.CLOB, TypeHandlerRegistry.createSingleTypeHandler(ClobTypeHandler.class));
        this.register(JDBCType.VARCHAR, TypeHandlerRegistry.createSingleTypeHandler(StringTypeHandler.class));
        this.register(JDBCType.LONGVARCHAR, TypeHandlerRegistry.createSingleTypeHandler(StringTypeHandler.class));
        this.register(JDBCType.NCLOB, TypeHandlerRegistry.createSingleTypeHandler(NClobTypeHandler.class));
        this.register(JDBCType.NVARCHAR, TypeHandlerRegistry.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(JDBCType.LONGNVARCHAR, TypeHandlerRegistry.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(JDBCType.TIMESTAMP, TypeHandlerRegistry.createSingleTypeHandler(DateTypeHandler.class));
        this.register(JDBCType.DATE, TypeHandlerRegistry.createSingleTypeHandler(DateOnlyTypeHandler.class));
        this.register(JDBCType.TIME, TypeHandlerRegistry.createSingleTypeHandler(TimeOnlyTypeHandler.class));
        this.register(JDBCType.TIME_WITH_TIMEZONE, TypeHandlerRegistry.createSingleTypeHandler(OffsetTimeForSqlTypeHandler.class));
        this.register(JDBCType.TIMESTAMP_WITH_TIMEZONE, TypeHandlerRegistry.createSingleTypeHandler(OffsetDateTimeForSqlTypeHandler.class));
        this.register(JDBCType.SQLXML, TypeHandlerRegistry.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.register(JDBCType.BINARY, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.VARBINARY, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.BLOB, TypeHandlerRegistry.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.register(JDBCType.LONGVARBINARY, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.JAVA_OBJECT, TypeHandlerRegistry.createSingleTypeHandler(ObjectTypeHandler.class));
        this.register(JDBCType.ARRAY, TypeHandlerRegistry.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register(JDBCType.OTHER, TypeHandlerRegistry.createSingleTypeHandler(UnknownTypeHandler.class));
        this.registerCrossChars(MonthDay.class, TypeHandlerRegistry.createSingleTypeHandler(MonthDayOfStringTypeHandler.class));
        this.registerCrossNChars(MonthDay.class, TypeHandlerRegistry.createSingleTypeHandler(MonthDayOfStringTypeHandler.class));
        this.registerCrossNumber(MonthDay.class, TypeHandlerRegistry.createSingleTypeHandler(MonthDayOfNumberTypeHandler.class));
        this.registerCrossChars(YearMonth.class, TypeHandlerRegistry.createSingleTypeHandler(YearMonthOfStringTypeHandler.class));
        this.registerCrossNChars(YearMonth.class, TypeHandlerRegistry.createSingleTypeHandler(YearMonthOfStringTypeHandler.class));
        this.registerCrossNumber(YearMonth.class, TypeHandlerRegistry.createSingleTypeHandler(YearMonthOfNumberTypeHandler.class));
        this.registerCrossChars(Year.class, TypeHandlerRegistry.createSingleTypeHandler(YearOfStringTypeHandler.class));
        this.registerCrossNChars(Year.class, TypeHandlerRegistry.createSingleTypeHandler(YearOfStringTypeHandler.class));
        this.registerCrossNumber(Year.class, TypeHandlerRegistry.createSingleTypeHandler(YearOfNumberTypeHandler.class));
        this.registerCrossChars(Month.class, TypeHandlerRegistry.createSingleTypeHandler(MonthOfStringTypeHandler.class));
        this.registerCrossNChars(Month.class, TypeHandlerRegistry.createSingleTypeHandler(MonthOfStringTypeHandler.class));
        this.registerCrossNumber(Month.class, TypeHandlerRegistry.createSingleTypeHandler(MonthOfNumberTypeHandler.class));
        this.registerCrossChars(String.class, TypeHandlerRegistry.createSingleTypeHandler(StringTypeHandler.class));
        this.registerCrossNChars(String.class, TypeHandlerRegistry.createSingleTypeHandler(NStringTypeHandler.class));
        this.registerCross(JDBCType.CLOB, String.class, TypeHandlerRegistry.createSingleTypeHandler(ClobTypeHandler.class));
        this.registerCross(JDBCType.NCLOB, String.class, TypeHandlerRegistry.createSingleTypeHandler(NClobTypeHandler.class));
        this.registerCrossChars(Reader.class, TypeHandlerRegistry.createSingleTypeHandler(StringReaderTypeHandler.class));
        this.registerCrossNChars(Reader.class, TypeHandlerRegistry.createSingleTypeHandler(NStringReaderTypeHandler.class));
        this.registerCross(JDBCType.CLOB, String.class, TypeHandlerRegistry.createSingleTypeHandler(ClobReaderTypeHandler.class));
        this.registerCross(JDBCType.NCLOB, String.class, TypeHandlerRegistry.createSingleTypeHandler(NClobReaderTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, String.class, TypeHandlerRegistry.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, Reader.class, TypeHandlerRegistry.createSingleTypeHandler(SqlXmlForReaderTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, InputStream.class, TypeHandlerRegistry.createSingleTypeHandler(SqlXmlForInputStreamTypeHandler.class));
        this.registerCross(JDBCType.BINARY, byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.BINARY, Byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, Byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.BLOB, byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.registerCross(JDBCType.BLOB, Byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BlobBytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, Byte[].class, TypeHandlerRegistry.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.BINARY, InputStream.class, TypeHandlerRegistry.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, InputStream.class, TypeHandlerRegistry.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.BLOB, InputStream.class, TypeHandlerRegistry.createSingleTypeHandler(BlobInputStreamTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, InputStream.class, TypeHandlerRegistry.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.ARRAY, Object.class, TypeHandlerRegistry.createSingleTypeHandler(ArrayTypeHandler.class));
    }

    private static TypeHandler<?> createSingleTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        cachedSingleHandlers.computeIfAbsent(typeHandler, type -> {
            try {
                if (typeHandler == UnknownTypeHandler.class) {
                    return new UnknownTypeHandler(DEFAULT);
                }
                return (TypeHandler)typeHandler.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        });
        return cachedSingleHandlers.get(typeHandler);
    }

    public void register(JDBCType jdbcType, TypeHandler<?> typeHandler) {
        this.jdbcTypeHandlerMap.put(jdbcType, typeHandler);
    }

    public void register(Type javaType, TypeHandler<?> typeHandler) {
        this.javaTypeHandlerMap.put(javaType, typeHandler);
    }

    private void registerCross(JDBCType jdbcType, Class<?> javaType, TypeHandler<?> typeHandler) {
        Map typeClassMap = this.typeHandlerMap.computeIfAbsent(javaType, k -> new ConcurrentHashMap());
        typeClassMap.put(jdbcType, typeHandler);
    }

    private void registerCrossChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.CHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.VARCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.LONGVARCHAR, jdbcType, typeHandler);
    }

    private void registerCrossNChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.NCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.NVARCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.LONGNVARCHAR, jdbcType, typeHandler);
    }

    private void registerCrossNumber(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.TINYINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.SMALLINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.INTEGER, jdbcType, typeHandler);
        this.registerCross(JDBCType.BIGINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.FLOAT, jdbcType, typeHandler);
        this.registerCross(JDBCType.DOUBLE, jdbcType, typeHandler);
        this.registerCross(JDBCType.REAL, jdbcType, typeHandler);
        this.registerCross(JDBCType.NUMERIC, jdbcType, typeHandler);
        this.registerCross(JDBCType.DECIMAL, jdbcType, typeHandler);
    }

    public void register(TypeHandler<?> typeHandler) {
        MappedCross[] mappedCrosses;
        MappedJdbcTypes mappedJdbcTypes;
        Class<?> handlerClass = typeHandler.getClass();
        MappedJavaTypes mappedTypes = handlerClass.getAnnotation(MappedJavaTypes.class);
        if (mappedTypes != null) {
            for (Class<?> handledType : mappedTypes.value()) {
                this.register(handledType, typeHandler);
            }
        }
        if ((mappedJdbcTypes = handlerClass.getAnnotation(MappedJdbcTypes.class)) != null) {
            for (JDBCType jdbcType : mappedJdbcTypes.value()) {
                if (typeHandler instanceof TypeReference) {
                    this.registerCross(jdbcType, ((TypeReference)typeHandler).getRawType(), typeHandler);
                    continue;
                }
                this.register(jdbcType, typeHandler);
            }
        }
        for (MappedCross cross : mappedCrosses = (MappedCross[])handlerClass.getAnnotationsByType(MappedCross.class)) {
            MappedJdbcTypes jdbcTypes = cross.jdbcType();
            MappedJavaTypes javaTypes = cross.javaTypes();
            for (Class<?> javaType : javaTypes.value()) {
                for (JDBCType jdbcType : jdbcTypes.value()) {
                    this.registerCross(jdbcType, javaType, typeHandler);
                }
            }
        }
    }

    public Collection<TypeHandler<?>> getTypeHandlers() {
        return Collections.unmodifiableCollection(this.javaTypeHandlerMap.values());
    }

    public static JDBCType toSqlType(Class<?> javaType) {
        JDBCType jdbcType = javaTypeToSqlTypeMap.get(javaType);
        if (jdbcType != null) {
            return jdbcType;
        }
        return JDBCType.OTHER;
    }

    public static Class<?> toJavaType(JDBCType jdbcType) {
        return jdbcTypeToJavaTypeMap.get(jdbcType);
    }

    public boolean hasTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        return this.javaTypeHandlerMap.containsKey(typeClass);
    }

    public boolean hasTypeHandler(JDBCType jdbcType) {
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        return this.jdbcTypeHandlerMap.containsKey(jdbcType);
    }

    public boolean hasTypeHandler(Class<?> typeClass, JDBCType jdbcType) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        Map<JDBCType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(typeClass);
        if (jdbcHandlerMap != null) {
            return jdbcHandlerMap.containsKey(jdbcType);
        }
        return false;
    }

    public TypeHandler<?> getTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        UnknownTypeHandler typeHandler = this.javaTypeHandlerMap.get(typeClass);
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    public TypeHandler<?> getTypeHandler(JDBCType jdbcType) {
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        UnknownTypeHandler typeHandler = this.jdbcTypeHandlerMap.get(jdbcType);
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    public TypeHandler<?> getTypeHandler(Class<?> typeClass, JDBCType jdbcType) {
        TypeHandler<?> typeHandler;
        Map<JDBCType, TypeHandler<?>> handlerMap;
        if (typeClass == null && jdbcType == null) {
            return this.defaultTypeHandler;
        }
        if (typeClass != null && jdbcType != null && (handlerMap = this.typeHandlerMap.get(typeClass)) != null && (typeHandler = handlerMap.get(jdbcType)) != null) {
            return typeHandler;
        }
        if (typeClass == null) {
            return this.getTypeHandler(jdbcType);
        }
        TypeHandler<?> typeHandler2 = this.javaTypeHandlerMap.get(typeClass);
        if (typeHandler2 != null) {
            return typeHandler2;
        }
        if (Enum.class.isAssignableFrom(typeClass) && (typeHandler2 = this.javaTypeHandlerMap.get(typeClass = typeClass.isAnonymousClass() ? typeClass.getSuperclass() : typeClass)) == null) {
            EnumTypeHandler enumOfStringTypeHandler = new EnumTypeHandler(typeClass);
            this.javaTypeHandlerMap.put(typeClass, enumOfStringTypeHandler);
            return enumOfStringTypeHandler;
        }
        if (typeHandler2 == null) {
            return this.getTypeHandler(typeClass);
        }
        return this.defaultTypeHandler;
    }

    public UnknownTypeHandler getDefaultTypeHandler() {
        return this.defaultTypeHandler;
    }

    static {
        javaTypeToSqlTypeMap.put(Boolean.class, JDBCType.BIT);
        javaTypeToSqlTypeMap.put(Boolean.TYPE, JDBCType.BIT);
        javaTypeToSqlTypeMap.put(Byte.class, JDBCType.TINYINT);
        javaTypeToSqlTypeMap.put(Byte.TYPE, JDBCType.TINYINT);
        javaTypeToSqlTypeMap.put(Short.class, JDBCType.SMALLINT);
        javaTypeToSqlTypeMap.put(Short.TYPE, JDBCType.SMALLINT);
        javaTypeToSqlTypeMap.put(Integer.class, JDBCType.INTEGER);
        javaTypeToSqlTypeMap.put(Integer.TYPE, JDBCType.INTEGER);
        javaTypeToSqlTypeMap.put(Long.class, JDBCType.BIGINT);
        javaTypeToSqlTypeMap.put(Long.TYPE, JDBCType.BIGINT);
        javaTypeToSqlTypeMap.put(Float.class, JDBCType.FLOAT);
        javaTypeToSqlTypeMap.put(Float.TYPE, JDBCType.FLOAT);
        javaTypeToSqlTypeMap.put(Double.class, JDBCType.DOUBLE);
        javaTypeToSqlTypeMap.put(Double.TYPE, JDBCType.DOUBLE);
        javaTypeToSqlTypeMap.put(Character.class, JDBCType.CHAR);
        javaTypeToSqlTypeMap.put(Character.TYPE, JDBCType.CHAR);
        javaTypeToSqlTypeMap.put(Date.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(java.sql.Date.class, JDBCType.DATE);
        javaTypeToSqlTypeMap.put(Timestamp.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(Time.class, JDBCType.TIME);
        javaTypeToSqlTypeMap.put(Instant.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(LocalDateTime.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(LocalDate.class, JDBCType.DATE);
        javaTypeToSqlTypeMap.put(LocalTime.class, JDBCType.TIME);
        javaTypeToSqlTypeMap.put(ZonedDateTime.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(JapaneseDate.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(YearMonth.class, JDBCType.VARCHAR);
        javaTypeToSqlTypeMap.put(Year.class, JDBCType.SMALLINT);
        javaTypeToSqlTypeMap.put(Month.class, JDBCType.SMALLINT);
        javaTypeToSqlTypeMap.put(OffsetDateTime.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(OffsetTime.class, JDBCType.TIMESTAMP);
        javaTypeToSqlTypeMap.put(String.class, JDBCType.VARCHAR);
        javaTypeToSqlTypeMap.put(BigInteger.class, JDBCType.BIGINT);
        javaTypeToSqlTypeMap.put(BigDecimal.class, JDBCType.DECIMAL);
        javaTypeToSqlTypeMap.put(Reader.class, JDBCType.CLOB);
        javaTypeToSqlTypeMap.put(InputStream.class, JDBCType.BLOB);
        javaTypeToSqlTypeMap.put(URL.class, JDBCType.DATALINK);
        javaTypeToSqlTypeMap.put(Byte[].class, JDBCType.VARBINARY);
        javaTypeToSqlTypeMap.put(byte[].class, JDBCType.VARBINARY);
        javaTypeToSqlTypeMap.put(Object[].class, JDBCType.ARRAY);
        javaTypeToSqlTypeMap.put(Object.class, JDBCType.JAVA_OBJECT);
    }
}

