/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.paramer;

import java.util.List;
import java.util.Objects;
import net.hasor.db.jdbc.SqlParameterSource;
import net.hasor.db.jdbc.core.ParameterDisposer;
import net.hasor.utils.BeanUtils;

public class BeanSqlParameterSource
implements SqlParameterSource,
ParameterDisposer {
    private final Object dataBean;
    private final List<String> dataNames;

    public BeanSqlParameterSource(Object dataBean) {
        this.dataBean = Objects.requireNonNull(dataBean);
        this.dataNames = BeanUtils.getPropertysAndFields(dataBean.getClass());
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.dataNames.contains(paramName);
    }

    @Override
    public Object getValue(String paramName) throws IllegalArgumentException {
        return BeanUtils.readPropertyOrField((Object)this.dataBean, (String)paramName);
    }

    @Override
    public String[] getParameterNames() {
        return this.dataNames.toArray(new String[0]);
    }

    @Override
    public void cleanupParameters() {
        if (this.dataBean instanceof ParameterDisposer) {
            ((ParameterDisposer)this.dataBean).cleanupParameters();
        }
    }
}

