/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.lambda.dialect;

import java.util.Map;
import net.hasor.db.jdbc.lambda.dialect.AliyunAdsDialect;
import net.hasor.db.jdbc.lambda.dialect.AliyunDRDSDialect;
import net.hasor.db.jdbc.lambda.dialect.Db2Dialect;
import net.hasor.db.jdbc.lambda.dialect.H2Dialect;
import net.hasor.db.jdbc.lambda.dialect.HSQLDialect;
import net.hasor.db.jdbc.lambda.dialect.HerdDBDialect;
import net.hasor.db.jdbc.lambda.dialect.HiveDialect;
import net.hasor.db.jdbc.lambda.dialect.ImpalaDialect;
import net.hasor.db.jdbc.lambda.dialect.InformixDialect;
import net.hasor.db.jdbc.lambda.dialect.MariaDBDialect;
import net.hasor.db.jdbc.lambda.dialect.MySqlDialect;
import net.hasor.db.jdbc.lambda.dialect.OracleDialect;
import net.hasor.db.jdbc.lambda.dialect.PhoenixDialect;
import net.hasor.db.jdbc.lambda.dialect.PostgreSqlDialect;
import net.hasor.db.jdbc.lambda.dialect.SqlDialect;
import net.hasor.db.jdbc.lambda.dialect.SqlLiteDialect;
import net.hasor.db.jdbc.lambda.dialect.SqlServer2012Dialect;
import net.hasor.utils.ref.LinkedCaseInsensitiveMap;

public class SqlDialectRegister {
    private static final Map<String, Class<?>> dialectAliasMap = new LinkedCaseInsensitiveMap();
    private static final Map<String, SqlDialect> dialectCache = new LinkedCaseInsensitiveMap();

    public static void registerDialectAlias(String alias, Class<? extends SqlDialect> dialectClass) {
        dialectAliasMap.put(alias, dialectClass);
    }

    public static void registerDialect(String dbType, SqlDialect sqlDialect) {
        dialectCache.put(dbType, sqlDialect);
    }

    public static SqlDialect findOrCreate(String dbType) {
        SqlDialect dialect = dialectCache.get(dbType);
        if (dialect != null) {
            return dialect;
        }
        Class<?> aClass = dialectAliasMap.get(dbType);
        if (aClass != null) {
            try {
                dialect = (SqlDialect)aClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("create dialect failed " + e.getMessage(), e);
            }
        } else {
            return SqlDialect.DEFAULT;
        }
        dialectCache.put(dbType, dialect);
        return dialect;
    }

    static {
        SqlDialectRegister.registerDialectAlias("postgresql", PostgreSqlDialect.class);
        SqlDialectRegister.registerDialectAlias("hsql", HSQLDialect.class);
        SqlDialectRegister.registerDialectAlias("phoenix", PhoenixDialect.class);
        SqlDialectRegister.registerDialectAlias("impala", ImpalaDialect.class);
        SqlDialectRegister.registerDialectAlias("mysql", MySqlDialect.class);
        SqlDialectRegister.registerDialectAlias("mariadb", MariaDBDialect.class);
        SqlDialectRegister.registerDialectAlias("aliyun_ads", AliyunAdsDialect.class);
        SqlDialectRegister.registerDialectAlias("aliyun_drds", AliyunDRDSDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlite", SqlLiteDialect.class);
        SqlDialectRegister.registerDialectAlias("herddb", HerdDBDialect.class);
        SqlDialectRegister.registerDialectAlias("sqlserver2012", SqlServer2012Dialect.class);
        SqlDialectRegister.registerDialectAlias("derby", SqlServer2012Dialect.class);
        SqlDialectRegister.registerDialectAlias("oracle", OracleDialect.class);
        SqlDialectRegister.registerDialectAlias("AliOracle", OracleDialect.class);
        SqlDialectRegister.registerDialectAlias("h2", H2Dialect.class);
        SqlDialectRegister.registerDialectAlias("hive", HiveDialect.class);
        SqlDialectRegister.registerDialectAlias("db2", Db2Dialect.class);
        SqlDialectRegister.registerDialectAlias("informix", InformixDialect.class);
    }
}

