/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.sql.Connection;
import java.util.function.Function;
import javax.sql.DataSource;
import net.hasor.db.transaction.TranManager;

public class JdbcAccessor {
    private DataSource dataSource;
    private Connection connection;
    private Function<DataSource, Connection> accessorApply = TranManager::currentConnection;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected Function<DataSource, Connection> getAccessorApply() {
        return this.accessorApply;
    }

    public void setAccessorApply(Function<DataSource, Connection> accessorApply) {
        this.accessorApply = accessorApply;
    }

    protected Connection applyConnection(DataSource dataSource) {
        if (this.accessorApply == null) {
            throw new IllegalArgumentException("accessorApply is null.");
        }
        return this.accessorApply.apply(dataSource);
    }
}

