/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction;

import java.sql.Connection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import net.hasor.db.datasource.ConnectionHolder;
import net.hasor.db.datasource.DataSourceManager;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.support.JdbcTransactionManager;

public class TranManager
extends DataSourceManager {
    private static final ThreadLocal<ConcurrentMap<DataSource, JdbcTransactionManager>> managerMap = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final ThreadLocal<ConcurrentMap<DataSource, ConnectionHolder>> currentMap = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public static ConnectionHolder currentConnectionHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        ConcurrentMap<DataSource, ConnectionHolder> localMap = currentMap.get();
        ConnectionHolder holder = (ConnectionHolder)localMap.get(dataSource);
        if (holder == null) {
            holder = localMap.putIfAbsent(dataSource, TranManager.newConnectionHolder(dataSource));
            holder = (ConnectionHolder)localMap.get(dataSource);
        }
        return holder;
    }

    public static Connection currentConnection(DataSource dataSource) {
        ConnectionHolder holder = TranManager.currentConnectionHolder(dataSource);
        return TranManager.newProxyConnection(holder);
    }

    protected static void currentConnection(DataSource dataSource, ConnectionHolder holder) {
        ConcurrentMap<DataSource, ConnectionHolder> localMap = currentMap.get();
        if (holder == null) {
            localMap.remove(dataSource);
        } else {
            localMap.put(dataSource, holder);
        }
    }

    private static synchronized JdbcTransactionManager getTransactionManager(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        ConcurrentMap<DataSource, JdbcTransactionManager> localMap = managerMap.get();
        JdbcTransactionManager manager = (JdbcTransactionManager)localMap.get(dataSource);
        if (manager == null) {
            manager = localMap.putIfAbsent(dataSource, new JdbcTransactionManager(dataSource){});
            manager = (JdbcTransactionManager)localMap.get(dataSource);
        }
        return manager;
    }

    public static synchronized TransactionManager getManager(DataSource dataSource) {
        return TranManager.getTransactionManager(dataSource);
    }

    public static synchronized TransactionTemplate getTemplate(DataSource dataSource) {
        JdbcTransactionManager manager = TranManager.getTransactionManager(dataSource);
        if (manager == null) {
            return null;
        }
        return manager.getTransactionTemplate();
    }
}

