/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

class InnerCallableStatementGetter {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap = new HashMap();

    InnerCallableStatementGetter() {
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Object getValue(CallableStatement cs, int index, Class<?> requiredType) throws SQLException {
        Object value = null;
        boolean wasNullCheck = false;
        if (requiredType == null) {
            return cs.getObject(index);
        }
        if (String.class.equals(requiredType = InnerCallableStatementGetter.primitiveToWrapper(requiredType))) {
            value = cs.getString(index);
        } else if (Integer.class.equals(requiredType)) {
            value = cs.getInt(index);
            wasNullCheck = true;
        } else if (Double.class.equals(requiredType)) {
            value = cs.getDouble(index);
            wasNullCheck = true;
        } else if (Boolean.class.equals(requiredType)) {
            value = cs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
            wasNullCheck = true;
        } else if (Date.class.equals(requiredType)) {
            value = cs.getDate(index);
        } else if (Time.class.equals(requiredType)) {
            value = cs.getTime(index);
        } else if (Timestamp.class.equals(requiredType)) {
            value = cs.getTimestamp(index);
        } else if (java.util.Date.class.equals(requiredType)) {
            value = new java.util.Date(cs.getTimestamp(index).getTime());
        } else if (Byte.class.equals(requiredType)) {
            value = cs.getByte(index);
            wasNullCheck = true;
        } else if (Short.class.equals(requiredType)) {
            value = cs.getShort(index);
            wasNullCheck = true;
        } else if (Long.class.equals(requiredType)) {
            value = cs.getLong(index);
            wasNullCheck = true;
        } else if (Float.class.equals(requiredType)) {
            value = Float.valueOf(cs.getFloat(index));
            wasNullCheck = true;
        } else if (Number.class.equals(requiredType)) {
            value = cs.getDouble(index);
            wasNullCheck = true;
        } else {
            value = byte[].class.equals(requiredType) ? (Object)cs.getBytes(index) : (BigDecimal.class.equals(requiredType) ? cs.getBigDecimal(index) : (Blob.class.equals(requiredType) ? cs.getBlob(index) : (Clob.class.equals(requiredType) ? cs.getClob(index) : (URL.class.equals(requiredType) ? cs.getURL(index) : cs.getObject(index)))));
        }
        if (wasNullCheck && value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        for (Class<?> primitiveClass : primitiveWrapperMap.keySet()) {
            Class<?> wrapperClass;
            if (primitiveClass.equals(wrapperClass = primitiveWrapperMap.get(primitiveClass))) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
    }
}

