/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mybatis3;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import net.hasor.db.jdbc.ConnectionCallback;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.mybatis3.SqlExecutorOperations;
import net.hasor.db.mybatis3.SqlSessionCallback;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlExecutorTemplate
extends JdbcTemplate
implements SqlExecutorOperations {
    private SqlSessionFactory sessionFactory;

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory, DataSource dataSource) {
        super(dataSource);
        this.sessionFactory = sessionFactory;
    }

    public SqlExecutorTemplate(SqlSessionFactory sessionFactory, Connection conn) {
        super(conn);
        this.sessionFactory = sessionFactory;
    }

    public SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public <T> T execute(SqlSessionCallback<T> sessionCallback) throws SQLException {
        Objects.requireNonNull(sessionCallback, "Callback object must not be null");
        ConnectionCallback<Object> callBack = con -> {
            try (SqlSession sqlSession = this.sessionFactory.openSession(con);){
                Object t = sessionCallback.doSqlSession(sqlSession);
                return t;
            }
        };
        return (T)((JdbcConnection)this).execute(callBack);
    }
}

