/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mybatis3;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import net.hasor.core.AppContext;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.utils.ExceptionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;

class InnerSqlMapperProxy<T>
implements Supplier<T>,
InvocationHandler {
    private Class<?> mapperType = null;
    private Object mapperObject = null;
    private Supplier<AppContext> appContext;

    public InnerSqlMapperProxy(Class<?> mapperType, Supplier<AppContext> provider) {
        this.mapperType = Objects.requireNonNull(mapperType, "mapperType is null.");
        this.appContext = provider;
    }

    @Override
    public T get() {
        if (this.mapperObject != null) {
            return (T)this.mapperObject;
        }
        try {
            this.mapperObject = Proxy.newProxyInstance(this.appContext.get().getClassLoader(), new Class[]{this.mapperType}, (InvocationHandler)this);
            return (T)this.mapperObject;
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntimeException((Throwable)e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            return this.mapperType.toString();
        }
        JdbcTemplate jdbcTemplate = (JdbcTemplate)this.appContext.get().getInstance(JdbcTemplate.class);
        SqlSessionFactory factory = (SqlSessionFactory)this.appContext.get().getInstance(SqlSessionFactory.class);
        return ((JdbcConnection)jdbcTemplate).execute(con -> {
            try (SqlSession sqlSession = factory.openSession(con);){
                Object mapper = sqlSession.getMapper(this.mapperType);
                Object object = method.invoke(mapper, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw new SQLException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
        });
    }
}

