/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hasor.db.jdbc.mapper.AbstractRowMapper;
import net.hasor.utils.BeanUtils;

public class BeanPropertyRowMapper<T>
extends AbstractRowMapper<T> {
    private Class<T> requiredType;
    private boolean caseInsensitive = false;
    private Map<String, String> columnMapping = new HashMap<String, String>();

    public BeanPropertyRowMapper() {
    }

    public BeanPropertyRowMapper(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        this.requiredType = requiredType;
        this.loadMapping();
    }

    public void setRequiredType(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        this.requiredType = requiredType;
        this.loadMapping();
    }

    private void loadMapping() {
        this.columnMapping.clear();
        List prop = BeanUtils.getPropertysAndFields(this.requiredType);
        for (String pName : prop) {
            this.columnMapping.put(pName.toUpperCase(), pName);
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            T targetObject = this.requiredType.newInstance();
            return this.tranResultSet(rs, targetObject);
        }
        catch (InstantiationException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
    }

    private T tranResultSet(ResultSet rs, T targetObject) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        for (int i = 1; i <= nrOfColumns; ++i) {
            Class paramType;
            String colName = rsmd.getColumnName(i);
            if (!this.caseInsensitive) {
                colName = this.columnMapping.get(colName.toUpperCase());
            }
            if ((paramType = BeanUtils.getPropertyOrFieldType(this.requiredType, (String)colName)) == null) continue;
            Object colValue = this.getColumnValue(rs, i, paramType);
            BeanUtils.writePropertyOrField(targetObject, (String)colName, (Object)colValue);
        }
        return targetObject;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class<?> requiredType) throws SQLException {
        Object resultData = BeanPropertyRowMapper.getResultSetValue(rs, index);
        if (requiredType != null) {
            return BeanPropertyRowMapper.convertValueToRequiredType(resultData, requiredType);
        }
        return resultData;
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass) {
        BeanPropertyRowMapper<T> newInstance = new BeanPropertyRowMapper<T>();
        newInstance.setRequiredType(mappedClass);
        return newInstance;
    }
}

