/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TransactionCallback;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.TransactionTemplate;

class TransactionTemplateManager
implements TransactionTemplate {
    private TransactionManager transactionManager;

    public TransactionTemplateManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(TransactionCallback<T> callBack) throws Throwable {
        return this.execute(callBack, Propagation.REQUIRED, Isolation.DEFAULT);
    }

    @Override
    public <T> T execute(TransactionCallback<T> callBack, Propagation behavior) throws Throwable {
        return this.execute(callBack, behavior, Isolation.DEFAULT);
    }

    @Override
    public <T> T execute(TransactionCallback<T> callBack, Propagation behavior, Isolation level) throws Throwable {
        TransactionStatus tranStatus = null;
        try {
            tranStatus = this.transactionManager.getTransaction(behavior, level);
            T t = callBack.doTransaction(tranStatus);
            return t;
        }
        catch (Throwable e) {
            if (tranStatus != null) {
                tranStatus.setRollbackOnly();
            }
            throw e;
        }
        finally {
            if (tranStatus != null && !tranStatus.isCompleted()) {
                this.transactionManager.commit(tranStatus);
            }
        }
    }
}

