/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.db.jdbc.BatchPreparedStatementSetter;
import net.hasor.db.jdbc.CallableStatementCallback;
import net.hasor.db.jdbc.CallableStatementCreator;
import net.hasor.db.jdbc.ConnectionCallback;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.PreparedStatementCallback;
import net.hasor.db.jdbc.PreparedStatementCreator;
import net.hasor.db.jdbc.PreparedStatementSetter;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.SqlParameterSource;
import net.hasor.db.jdbc.StatementCallback;
import net.hasor.db.jdbc.core.InnerArgPreparedStatementSetter;
import net.hasor.db.jdbc.core.InnerStatementSetterUtils;
import net.hasor.db.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.ParameterDisposer;
import net.hasor.db.jdbc.core.ParsedSql;
import net.hasor.db.jdbc.core.RowMapperResultSetExtractor;
import net.hasor.db.jdbc.mapper.BeanPropertyRowMapper;
import net.hasor.db.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.db.jdbc.mapper.SingleColumnRowMapper;
import net.hasor.db.jdbc.paramer.MapSqlParameterSource;
import net.hasor.db.jdbc.result.LinkedCaseInsensitiveMap;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.io.IOUtils;

public class JdbcTemplate
extends JdbcConnection
implements JdbcOperations {
    private boolean ignoreWarnings = true;
    private boolean resultsCaseInsensitive = false;
    private final Map<String, ParsedSql> parsedSqlCache = new HashMap<String, ParsedSql>();

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public JdbcTemplate(Connection conn) {
        super(conn);
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isResultsCaseInsensitive() {
        return this.resultsCaseInsensitive;
    }

    public void setResultsCaseInsensitive(boolean resultsCaseInsensitive) {
        this.resultsCaseInsensitive = resultsCaseInsensitive;
    }

    public void loadSQL(String sqlResource) throws IOException, SQLException {
        this.loadSQL("UTF-8", sqlResource);
    }

    public void loadSQL(String charsetName, String sqlResource) throws IOException, SQLException {
        InputStream inStream = ResourcesUtils.getResourceAsStream((String)sqlResource);
        if (inStream == null) {
            throw new IOException("can't find :" + sqlResource);
        }
        InputStreamReader reader = new InputStreamReader(inStream, Charset.forName(charsetName));
        this.loadSQL(reader);
    }

    public void loadSQL(Reader sqlReader) throws IOException, SQLException {
        StringWriter outWriter = new StringWriter();
        IOUtils.copy((Reader)sqlReader, (Writer)outWriter);
        this.execute(outWriter.toString());
    }

    @Override
    public <T> T execute(final StatementCallback<T> action) throws SQLException {
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        return ((JdbcConnection)this).execute(new ConnectionCallback<T>(){

            @Override
            public T doInConnection(Connection con) throws SQLException {
                try (Statement stmt = null;){
                    stmt = con.createStatement();
                    JdbcTemplate.this.applyStatementSettings(stmt);
                    Object result = action.doInStatement(stmt);
                    JdbcTemplate.this.handleWarnings(stmt);
                    Object t = result;
                    return t;
                }
            }
        });
    }

    @Override
    public <T> T execute(final PreparedStatementCreator psc, final PreparedStatementCallback<T> action) throws SQLException {
        Hasor.assertIsNotNull((Object)psc, (String)"PreparedStatementCreator must not be null");
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql = JdbcTemplate.getSql(psc);
            this.logger.debug("Executing prepared SQL statement " + (sql != null ? " [" + sql + "]" : ""));
        }
        return ((JdbcConnection)this).execute(new ConnectionCallback<T>(){

            @Override
            public T doInConnection(Connection con) throws SQLException {
                PreparedStatement ps = null;
                try {
                    ps = psc.createPreparedStatement(con);
                    JdbcTemplate.this.applyStatementSettings(ps);
                    Object result = action.doInPreparedStatement(ps);
                    JdbcTemplate.this.handleWarnings(ps);
                    Object t = result;
                    return t;
                }
                catch (SQLException ex) {
                    if (ps != null) {
                        JdbcTemplate.this.logger.error(ps.toString());
                    }
                    throw ex;
                }
                finally {
                    if (psc instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)psc)).cleanupParameters();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        });
    }

    @Override
    public <T> T execute(final CallableStatementCreator csc, final CallableStatementCallback<T> action) throws SQLException {
        Hasor.assertIsNotNull((Object)csc, (String)"CallableStatementCreator must not be null");
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql = JdbcTemplate.getSql(csc);
            this.logger.debug("Calling stored procedure" + (sql != null ? " [" + sql + "]" : ""));
        }
        return ((JdbcConnection)this).execute(new ConnectionCallback<T>(){

            @Override
            public T doInConnection(Connection con) throws SQLException {
                CallableStatement cs = null;
                try {
                    cs = csc.createCallableStatement(con);
                    JdbcTemplate.this.applyStatementSettings(cs);
                    Object result = action.doInCallableStatement(cs);
                    JdbcTemplate.this.handleWarnings(cs);
                    Object t = result;
                    return t;
                }
                catch (SQLException ex) {
                    String sqlString = JdbcTemplate.getSql(action);
                    throw new SQLException("CallableStatementCallback SQL :" + sqlString, ex);
                }
                finally {
                    if (csc instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)csc)).cleanupParameters();
                    }
                    if (cs != null) {
                        cs.close();
                    }
                }
            }
        });
    }

    @Override
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    @Override
    public <T> T execute(String callString, CallableStatementCallback<T> action) throws SQLException {
        return this.execute(new SimpleCallableStatementCreator(callString), action);
    }

    @Override
    public <T> T execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(this.getPreparedStatementCreator(sql, paramSource), action);
    }

    @Override
    public <T> T execute(String sql, Map<String, ?> paramMap, PreparedStatementCallback<T> action) throws SQLException {
        return this.execute(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), action);
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL statement [{}].", (Object)sql);
        }
        class ExecuteStatementCallback
        implements StatementCallback<Boolean>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Boolean doInStatement(Statement stmt) throws SQLException {
                return stmt.execute(sql);
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new ExecuteStatementCallback());
    }

    public <T> T query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor<T> rse) throws SQLException {
        Hasor.assertIsNotNull(rse, (String)"ResultSetExtractor must not be null.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing prepared SQL query");
        }
        return this.execute(psc, new PreparedStatementCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInPreparedStatement(PreparedStatement ps) throws SQLException {
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    rs = ps.executeQuery();
                    Object t = rse.extractData(rs);
                    return t;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(psc, null, rse);
    }

    @Override
    public <T> T query(final String sql, final ResultSetExtractor<T> rse) throws SQLException {
        Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null.");
        Hasor.assertIsNotNull(rse, (String)"ResultSetExtractor must not be null.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL query [{}].", (Object)sql);
        }
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInStatement(Statement stmt) throws SQLException {
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery(sql);
                    Object t = rse.extractData(rs);
                    return t;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    rs = null;
                }
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    @Override
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Override
    public <T> T query(String sql, ResultSetExtractor<T> rse, Object ... args) throws SQLException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rse);
    }

    @Override
    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rse);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws SQLException {
        this.query(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, RowCallbackHandler rch) throws SQLException {
        this.query(sql, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws SQLException {
        this.query(sql, pss, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, RowCallbackHandler rch, Object ... args) throws SQLException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    @Override
    public void query(String sql, Object[] args, RowCallbackHandler rch) throws SQLException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    @Override
    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws SQLException {
        this.query(this.getPreparedStatementCreator(sql, paramSource), rch);
    }

    @Override
    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws SQLException {
        this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rch);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(psc, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, pss, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws SQLException {
        return (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(sql, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
    }

    @Override
    public <T> List<T> query(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        return this.query(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rowMapper);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType) throws SQLException {
        return this.query(sql, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) throws SQLException {
        return this.query(sql, args, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws SQLException {
        return this.query(sql, args, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws SQLException {
        return this.query(sql, paramSource, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws SQLException {
        return this.query(sql, paramMap, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws SQLException {
        List<T> results = this.query(sql, rowMapper);
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws SQLException {
        List results = (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        List results = (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        List<T> results = this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws SQLException {
        return this.queryForObject(sql, args, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, args, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramSource, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramMap, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public long queryForLong(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Long.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object ... args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Long.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Number.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForLong(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int queryForInt(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Integer.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object ... args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Integer.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Number.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForInt(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public Map<String, Object> queryForMap(String sql) throws SQLException {
        return this.queryForObject(sql, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) throws SQLException {
        return this.queryForObject(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.queryForObject(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForObject(sql, paramMap, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql) throws SQLException {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws SQLException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.query(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap));
    }

    public int executeUpdate(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing prepared SQL update");
        }
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (JdbcTemplate.this.logger.isDebugEnabled()) {
                        JdbcTemplate.this.logger.debug("SQL update affected {} rows", (Object)rows);
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public int executeUpdate(PreparedStatementCreator psc) throws SQLException {
        return this.executeUpdate(psc, null);
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL update [{}]", (Object)sql);
        }
        class UpdateStatementCallback
        implements StatementCallback<Integer>,
        SqlProvider {
            UpdateStatementCallback() {
            }

            @Override
            public Integer doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(sql);
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug("SQL update affected {} rows.", (Object)rows);
                }
                return rows;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new UpdateStatementCallback());
    }

    @Override
    public int executeUpdate(String sql, PreparedStatementSetter pss) throws SQLException {
        return this.executeUpdate(new SimplePreparedStatementCreator(sql), pss);
    }

    @Override
    public int executeUpdate(String sql, Object ... args) throws SQLException {
        return this.executeUpdate(sql, this.newArgPreparedStatementSetter(args));
    }

    @Override
    public int executeUpdate(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.executeUpdate(this.getPreparedStatementCreator(sql, paramSource));
    }

    @Override
    public int executeUpdate(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.executeUpdate(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)));
    }

    @Override
    public int[] executeBatch(final String[] sql) throws SQLException {
        if (sql == null || sql.length == 0) {
            throw new NullPointerException("SQL array must not be empty");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update of {} statements", (Object)sql.length);
        }
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public int[] doInStatement(Statement stmt) throws SQLException {
                DatabaseMetaData dbmd = stmt.getConnection().getMetaData();
                int[] rowsAffected = new int[sql.length];
                if (dbmd.supportsBatchUpdates()) {
                    String[] stringArray = sql;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String sqlStmt;
                        this.currSql = sqlStmt = stringArray[i];
                        stmt.addBatch(sqlStmt);
                    }
                    rowsAffected = stmt.executeBatch();
                } else {
                    for (int i = 0; i < sql.length; ++i) {
                        this.currSql = sql[i];
                        if (stmt.execute(sql[i])) {
                            throw new SQLException("Invalid batch SQL statement: " + sql[i]);
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public int[] executeBatch(String sql, Map<String, ?>[] batchValues) throws SQLException {
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map<String, ?> values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.executeBatch(sql, batchArgs);
    }

    @Override
    public int[] executeBatch(String sql, SqlParameterSource[] batchArgs) throws SQLException {
        if (batchArgs.length <= 0) {
            return new int[]{0};
        }
        return this.executeBatch(sql, new SqlParameterSourceBatchPreparedStatementSetter(sql, batchArgs));
    }

    @Override
    public int[] executeBatch(String sql, final BatchPreparedStatementSetter pss) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update [{}].", (Object)sql);
        }
        ParsedSql parsedSql = this.getParsedSql(sql);
        sql = ParsedSql.buildSql(parsedSql, null);
        return this.execute(sql, new PreparedStatementCallback<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    int batchSize = pss.getBatchSize();
                    InterruptibleBatchPreparedStatementSetter ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                    DatabaseMetaData dbMetaData = ps.getConnection().getMetaData();
                    if (dbMetaData.supportsBatchUpdates()) {
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            if (ipss != null && ipss.isBatchExhausted(i)) break;
                            ps.addBatch();
                        }
                        int[] i = ps.executeBatch();
                        return i;
                    }
                    ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (ipss != null && ipss.isBatchExhausted(i)) break;
                        rowsAffected.add(ps.executeUpdate());
                    }
                    int[] rowsAffectedArray = new int[rowsAffected.size()];
                    for (int i = 0; i < rowsAffectedArray.length; ++i) {
                        rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                    }
                    int[] nArray = rowsAffectedArray;
                    return nArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper(){

            @Override
            protected Map<String, Object> createColumnMap(int columnCount) {
                return JdbcTemplate.this.createResultsMap();
            }
        };
    }

    protected <T> RowMapper<T> getBeanPropertyRowMapper(Class<T> requiredType) {
        Hasor.assertIsNotNull(requiredType, (String)"requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            return this.getColumnMapRowMapper();
        }
        if (requiredType.isPrimitive() || Number.class.isAssignableFrom(requiredType) || String.class.isAssignableFrom(requiredType)) {
            return this.getSingleColumnRowMapper(requiredType);
        }
        return new BeanPropertyRowMapper<T>(requiredType){

            @Override
            public boolean isCaseInsensitive() {
                return JdbcTemplate.this.isResultsCaseInsensitive();
            }
        };
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new SingleColumnRowMapper<T>(requiredType);
    }

    protected Map<String, Object> createResultsMap() {
        if (!this.isResultsCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap<Object>();
        }
        return new LinkedHashMap<String, Object>();
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) throws SQLException {
        return new InnerArgPreparedStatementSetter(args);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        return new MapPreparedStatementCreator(sql, paramSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String originalSql) {
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(originalSql);
            if (parsedSql == null) {
                parsedSql = ParsedSql.getParsedSql(originalSql);
                this.parsedSqlCache.put(originalSql, parsedSql);
            }
            return parsedSql;
        }
    }

    private void handleWarnings(Statement stmt) throws SQLException {
        if (this.isIgnoreWarnings()) {
            if (this.logger.isDebugEnabled()) {
                for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    this.logger.debug("SQLWarning ignored: SQL state '{}', error code '{}', message [{}].", new Object[]{warningToLog.getSQLState(), warningToLog.getErrorCode(), warningToLog.getMessage()});
                }
            }
        } else {
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                throw new SQLException("Warning not ignored", warning);
            }
        }
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static <T> T requiredSingleResult(Collection<T> results) throws SQLException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        int size = results.size();
        if (size > 1) {
            throw new SQLException("Incorrect column count: expected 1, actual " + size);
        }
        return results.iterator().next();
    }

    private class SqlParameterSourceBatchPreparedStatementSetter
    implements BatchPreparedStatementSetter,
    ParameterDisposer {
        private ParsedSql parsedSql = null;
        private SqlParameterSource[] batchArgs = null;

        public SqlParameterSourceBatchPreparedStatementSetter(String sql, SqlParameterSource[] batchArgs) {
            this.parsedSql = JdbcTemplate.this.getParsedSql(sql);
            this.batchArgs = batchArgs;
        }

        @Override
        public void setValues(PreparedStatement ps, int index) throws SQLException {
            SqlParameterSource paramSource = this.batchArgs[index];
            Object[] sqlValue = ParsedSql.buildSqlValues(this.parsedSql, paramSource);
            int sqlColIndx = 1;
            for (Object element : sqlValue) {
                InnerStatementSetterUtils.setParameterValue(ps, sqlColIndx++, element);
            }
        }

        @Override
        public int getBatchSize() {
            return this.batchArgs.length;
        }

        @Override
        public void cleanupParameters() {
            for (SqlParameterSource batchItem : this.batchArgs) {
                if (!(batchItem instanceof ParameterDisposer)) continue;
                ((ParameterDisposer)((Object)batchItem)).cleanupParameters();
            }
        }
    }

    private class MapPreparedStatementCreator
    implements PreparedStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private ParsedSql parsedSql = null;
        private SqlParameterSource paramSource = null;

        public MapPreparedStatementCreator(String originalSql, SqlParameterSource paramSource) {
            Hasor.assertIsNotNull((Object)originalSql, (String)"SQL must not be null");
            this.parsedSql = JdbcTemplate.this.getParsedSql(originalSql);
            this.paramSource = paramSource;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            String sqlToUse = ParsedSql.buildSql(this.parsedSql, this.paramSource);
            Object[] paramArray = ParsedSql.buildSqlValues(this.parsedSql, this.paramSource);
            PreparedStatement statement = con.prepareStatement(sqlToUse);
            for (int i = 0; i < paramArray.length; ++i) {
                InnerStatementSetterUtils.setParameterValue(statement, i + 1, paramArray[i]);
            }
            InnerStatementSetterUtils.cleanupParameters(paramArray);
            return statement;
        }

        @Override
        public String getSql() {
            return this.parsedSql.getOriginalSql();
        }

        @Override
        public void cleanupParameters() {
            if (this.paramSource instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.paramSource)).cleanupParameters();
            }
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Override
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            Hasor.assertIsNotNull((Object)callString, (String)"Call string must not be null");
            this.callString = callString;
        }

        @Override
        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            return con.prepareCall(this.callString);
        }

        @Override
        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null");
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }

    protected static interface SqlProvider {
        public String getSql();
    }
}

