/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.db.datasource.ConnectionHolder;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TranManager;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.support.JdbcTransactionStatus;
import net.hasor.db.transaction.support.SyncTransactionManager;
import net.hasor.db.transaction.support.TransactionObject;
import net.hasor.db.transaction.support.TransactionTemplateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransactionManager
implements TransactionManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedList<JdbcTransactionStatus> tStatusStack = new LinkedList();
    private DataSource dataSource = null;
    private TransactionTemplateManager transactionTemplate = null;

    protected JdbcTransactionManager(DataSource dataSource) {
        Hasor.assertIsNotNull((Object)dataSource);
        this.dataSource = dataSource;
        this.transactionTemplate = new TransactionTemplateManager(this);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean hasTransaction() {
        return !this.tStatusStack.isEmpty();
    }

    @Override
    public boolean isTopTransaction(TransactionStatus status) {
        if (this.tStatusStack.isEmpty()) {
            return false;
        }
        return this.tStatusStack.peek() == status;
    }

    @Override
    public final TransactionStatus getTransaction(Propagation behavior) throws SQLException {
        return this.getTransaction(behavior, Isolation.DEFAULT);
    }

    @Override
    public final TransactionStatus getTransaction(Propagation behavior, Isolation level) throws SQLException {
        Hasor.assertIsNotNull((Object)((Object)behavior));
        Hasor.assertIsNotNull((Object)((Object)level));
        JdbcTransactionStatus defStatus = new JdbcTransactionStatus(behavior, level);
        defStatus.setTranConn(this.doGetConnection(defStatus));
        this.tStatusStack.addFirst(defStatus);
        if (this.isExistingTransaction(defStatus)) {
            if (behavior == Propagation.REQUIRES_NEW) {
                this.suspend(defStatus);
                this.doBegin(defStatus);
            }
            if (behavior == Propagation.NESTED) {
                defStatus.markHeldSavepoint();
            }
            if (behavior == Propagation.NOT_SUPPORTED) {
                this.suspend(defStatus);
            }
            if (behavior == Propagation.NEVER) {
                this.cleanupAfterCompletion(defStatus);
                throw new SQLException("Existing transaction found for transaction marked with propagation 'never'");
            }
            return defStatus;
        }
        if (behavior == Propagation.REQUIRED || behavior == Propagation.REQUIRES_NEW || behavior == Propagation.NESTED) {
            this.doBegin(defStatus);
        }
        if (behavior == Propagation.MANDATORY) {
            this.cleanupAfterCompletion(defStatus);
            throw new SQLException("No existing transaction found for transaction marked with propagation 'mandatory'");
        }
        return defStatus;
    }

    private boolean isExistingTransaction(JdbcTransactionStatus defStatus) throws SQLException {
        return defStatus.getTranConn().hasTransaction();
    }

    protected void doBegin(JdbcTransactionStatus defStatus) throws SQLException {
        TransactionObject tranConn = defStatus.getTranConn();
        tranConn.beginTransaction();
    }

    @Override
    public final void commit(TransactionStatus status) throws SQLException {
        JdbcTransactionStatus defStatus = (JdbcTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new SQLException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        if (defStatus.isReadOnly() || defStatus.isRollbackOnly()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Transactional code has requested rollback");
            }
            this.rollBack(defStatus);
            return;
        }
        try {
            this.prepareCommit(defStatus);
            if (defStatus.hasSavepoint()) {
                defStatus.releaseHeldSavepoint();
            } else if (defStatus.isNewConnection()) {
                this.doCommit(defStatus);
            }
        }
        catch (SQLException ex) {
            this.doRollback(defStatus);
            throw ex;
        }
        finally {
            this.cleanupAfterCompletion(defStatus);
        }
    }

    private void prepareCommit(JdbcTransactionStatus defStatus) throws SQLException {
        if (!this.tStatusStack.contains(defStatus)) {
            throw new SQLException("This transaction is not derived from this Manager.");
        }
        TransactionStatus inStackStatus = null;
        while ((inStackStatus = (TransactionStatus)this.tStatusStack.peek()) != defStatus) {
            this.commit(inStackStatus);
        }
    }

    protected void doCommit(JdbcTransactionStatus defStatus) throws SQLException {
        TransactionObject tranObject = defStatus.getTranConn();
        tranObject.commit();
    }

    @Override
    public final void rollBack(TransactionStatus status) throws SQLException {
        JdbcTransactionStatus defStatus = (JdbcTransactionStatus)status;
        if (defStatus.isCompleted()) {
            throw new SQLException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        try {
            this.prepareRollback(defStatus);
            if (defStatus.hasSavepoint()) {
                defStatus.rollbackToHeldSavepoint();
            } else if (defStatus.isNewConnection()) {
                this.doRollback(defStatus);
            }
        }
        catch (SQLException ex) {
            this.doRollback(defStatus);
            throw ex;
        }
        finally {
            this.cleanupAfterCompletion(defStatus);
        }
    }

    private void prepareRollback(JdbcTransactionStatus defStatus) throws SQLException {
        if (!this.tStatusStack.contains(defStatus)) {
            throw new SQLException("This transaction is not derived from this Manager.");
        }
        TransactionStatus inStackStatus = null;
        while ((inStackStatus = (TransactionStatus)this.tStatusStack.peek()) != defStatus) {
            this.rollBack(inStackStatus);
        }
    }

    protected void doRollback(JdbcTransactionStatus defStatus) throws SQLException {
        TransactionObject tranObject = defStatus.getTranConn();
        tranObject.rollback();
    }

    protected final void suspend(JdbcTransactionStatus defStatus) throws SQLException {
        if (defStatus.isSuspend()) {
            throw new SQLException("the Transaction has Suspend.");
        }
        this.prepareCheckStack(defStatus);
        TransactionObject tranConn = defStatus.getTranConn();
        defStatus.setSuspendConn(tranConn);
        SyncTransactionManager.clearSync(this.getDataSource());
        defStatus.setTranConn(this.doGetConnection(defStatus));
    }

    protected final void resume(JdbcTransactionStatus defStatus) throws SQLException {
        if (!defStatus.isCompleted()) {
            throw new SQLException("the Transaction has not completed.");
        }
        if (!defStatus.isSuspend()) {
            throw new SQLException("the Transaction has not Suspend.");
        }
        this.prepareCheckStack(defStatus);
        if (defStatus.isSuspend()) {
            TransactionObject tranConn = defStatus.getSuspendConn();
            SyncTransactionManager.setSync(tranConn);
            defStatus.setTranConn(tranConn);
            defStatus.setSuspendConn(null);
            tranConn.getHolder().released();
        }
    }

    private void prepareCheckStack(JdbcTransactionStatus defStatus) throws SQLException {
        if (!this.isTopTransaction(defStatus)) {
            throw new SQLException("the Transaction Status is not top in stack.");
        }
    }

    private void cleanupAfterCompletion(JdbcTransactionStatus defStatus) throws SQLException {
        this.prepareCheckStack(defStatus);
        defStatus.setCompleted();
        TransactionObject tranObj = defStatus.getTranConn();
        Isolation transactionIsolation = tranObj.getOriIsolationLevel();
        if (transactionIsolation != null) {
            tranObj.getHolder().getConnection().setTransactionIsolation(transactionIsolation.ordinal());
        }
        tranObj.getHolder().released();
        tranObj.stopTransaction();
        if (defStatus.isSuspend()) {
            this.resume(defStatus);
        }
        this.tStatusStack.removeFirst();
        defStatus.setTranConn(null);
        defStatus.setSuspendConn(null);
    }

    protected TransactionObject doGetConnection(JdbcTransactionStatus defStatus) throws SQLException {
        ConnectionHolder holder = TranManager.currentConnectionHolder(this.dataSource);
        if (!holder.isOpen() || !holder.hasTransaction()) {
            defStatus.markNewConnection();
        }
        holder.requested();
        int isolationLevel = holder.getConnection().getTransactionIsolation();
        Isolation level = null;
        if (defStatus.getIsolationLevel() != Isolation.DEFAULT) {
            holder.getConnection().setTransactionIsolation(defStatus.getIsolationLevel().ordinal());
            level = Isolation.valueOf(isolationLevel);
        }
        return new TransactionObject(holder, level, this.getDataSource());
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }
}

