/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.MethodInvocation;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TranManager;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.interceptor.Transactional;

public class TransactionInterceptor
implements MethodInterceptor {
    private Supplier<DataSource> dataSource = null;

    public TransactionInterceptor(Supplier<DataSource> dataSource) {
        this.dataSource = (Supplier)Hasor.assertIsNotNull(dataSource, (String)"dataSource Provider is null.");
    }

    private boolean testNoRollBackFor(Transactional tranAnno, Throwable e) {
        Class<? extends Throwable>[] noRollBackType;
        for (Class<? extends Throwable> cls : noRollBackType = tranAnno.noRollbackFor()) {
            if (!cls.isInstance(e)) continue;
            return true;
        }
        String[] noRollBackName = tranAnno.noRollbackForClassName();
        String errorType = e.getClass().getName();
        for (String name : noRollBackName) {
            if (!errorType.equals(name)) continue;
            return true;
        }
        return false;
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Method targetMethod = invocation.getMethod();
        Transactional tranInfo = this.tranAnnotation(targetMethod);
        if (tranInfo == null) {
            return invocation.proceed();
        }
        DataSource dataSource = this.dataSource.get();
        TransactionManager manager = TranManager.getManager(dataSource);
        Propagation behavior = tranInfo.propagation();
        Isolation level = tranInfo.isolation();
        TransactionStatus tranStatus = manager.getTransaction(behavior, level);
        if (tranInfo.readOnly()) {
            tranStatus.setReadOnly();
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable e) {
            if (!this.testNoRollBackFor(tranInfo, e)) {
                tranStatus.setRollbackOnly();
            }
            throw e;
        }
        finally {
            if (!tranStatus.isCompleted()) {
                manager.commit(tranStatus);
            }
        }
    }

    private Transactional tranAnnotation(Method targetMethod) {
        Transactional tran = targetMethod.getAnnotation(Transactional.class);
        if (tran == null) {
            Class<?> declaringClass = targetMethod.getDeclaringClass();
            tran = declaringClass.getAnnotation(Transactional.class);
        }
        return tran;
    }
}

