/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.core.Hasor;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.convert.ConverterUtils;

public abstract class AbstractRowMapper<T>
implements RowMapper<T> {
    protected static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    protected static Object convertValueToRequiredType(Object value, Class<?> requiredType) {
        if (value == null) {
            return BeanUtils.getDefaultValue(requiredType);
        }
        if (String.class.equals(requiredType)) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(requiredType) || AbstractRowMapper.isNumberPrimitive(requiredType)) {
            if (value instanceof Number || AbstractRowMapper.isNumberPrimitive(requiredType)) {
                return AbstractRowMapper.convertNumberToTargetClass((Number)value, requiredType);
            }
            return AbstractRowMapper.parseNumber(value.toString(), requiredType);
        }
        return ConverterUtils.convert(requiredType, (Object)value);
    }

    private static boolean isNumberPrimitive(Class<?> requiredType) {
        return Byte.TYPE == requiredType || Short.TYPE == requiredType || Integer.TYPE == requiredType || Long.TYPE == requiredType || Float.TYPE == requiredType || Double.TYPE == requiredType;
    }

    private static Number parseNumber(String text, Class<?> targetClass) {
        Hasor.assertIsNotNull((Object)text, (String)"Text must not be null");
        Hasor.assertIsNotNull(targetClass, (String)"Target class must not be null");
        String trimmed = text.trim();
        if (targetClass.equals(Byte.class)) {
            return AbstractRowMapper.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed);
        }
        if (targetClass.equals(Short.class)) {
            return AbstractRowMapper.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed);
        }
        if (targetClass.equals(Integer.class)) {
            return AbstractRowMapper.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed);
        }
        if (targetClass.equals(Long.class)) {
            return AbstractRowMapper.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed);
        }
        if (targetClass.equals(BigInteger.class)) {
            return AbstractRowMapper.isHexNumber(trimmed) ? AbstractRowMapper.decodeBigInteger(trimmed) : new BigInteger(trimmed);
        }
        if (targetClass.equals(Float.class)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    private static Number convertNumberToTargetClass(Number number, Class<?> targetClass) throws IllegalArgumentException {
        Hasor.assertIsNotNull((Object)number, (String)"Number must not be null");
        Hasor.assertIsNotNull(targetClass, (String)"Target class must not be null");
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                AbstractRowMapper.raiseOverflowException(number, targetClass);
            }
            return new Byte(number.byteValue());
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                AbstractRowMapper.raiseOverflowException(number, targetClass);
            }
            return new Short(number.shortValue());
        }
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                AbstractRowMapper.raiseOverflowException(number, targetClass);
            }
            return new Integer(number.intValue());
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return new Long(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
            return new Float(number.floatValue());
        }
        if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
            return new Double(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static void raiseOverflowException(Number number, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

